#!/bin/bash
set -o pipefail

BASE="$HOME/PPF-LAB-V08"
cd "$BASE" || { echo "Base directory not found"; exit 1; }

PASS_COUNT=0
FAIL_COUNT=0

GREEN="\033[0;32m"
RED="\033[0;31m"
RESET="\033[0m"

run_test() {
    local name="$1"
    local cmd="$2"
    local expect="$3"

    echo "Running $name..."
    output=$(eval "$cmd" 2>&1)
    if echo "$output" | grep -q "$expect"; then
        echo -e "TEST $name ${GREEN}PASSED${RESET}"
        PASS_COUNT=$((PASS_COUNT+1))
    else
        echo -e "TEST $name ${RED}FAILED${RESET}"
        echo "--- Output was ---"
        echo "$output"
        echo "------------------"
        FAIL_COUNT=$((FAIL_COUNT+1))
    fi
}

# === Test 0: deviceQuery ===
cd "$BASE/00deviceQuery" || exit 1
make || exit 1
run_test "deviceQuery" "./deviceQuery" "Result = PASS"

cd "$BASE" || exit 1

# === Test 1: matrix_multiplication ===
nvcc 02matrix_multiplication.cu -o matrix_mul || exit 1
run_test "matrix_mul" "./matrix_mul" "Matrix size: 1024x1024"

# === Test 2: piEstimate ===
cd "$BASE/03piEstimate" || exit 1
make || exit 1
run_test "piEstimate" "./piEstimate 10000000 128" "GPU Result ="

cd "$BASE" || exit 1

# === Test 3: dotProd (modes 1..4) ===
cd "$BASE/04dotProd" || exit 1
make || exit 1
for m in 1 2 3; do
    run_test "dotProd-$m" "./dotProd 1000 128 $m" "Comparing the results... CPU Result ="
done
# test 4 expected failure (GPU result = 0), so check that
run_test "dotProd-4" "./dotProd 1000 128 4" "GPU Result = 0.000000"

cd "$BASE" || exit 1

# === Test 4: cudaOpenMP ===
cd "$BASE/05cudaOpenMP" || exit 1
make || exit 1
run_test "cudaOpenMP" "./cudaOpenMP" "Starting..."

cd "$BASE" || exit 1

# === Test 5: matrixMul sample ===
cd "$BASE/06matrixMul" || exit 1
make || exit 1
run_test "matrixMul-sample" "./matrixMul" "Result = PASS"

cd "$BASE" || exit 1

# === Final summary ===
echo
if [ "$FAIL_COUNT" -eq 0 ]; then
    echo -e "${GREEN}All $PASS_COUNT tests PASSED${RESET}"
else
    echo -e "${RED}$FAIL_COUNT tests FAILED${RESET}, $PASS_COUNT passed"
    exit 1
fi
