/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.run;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import rars.Globals;
import rars.Settings;
import rars.SimulationException;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.ProgramArgumentList;
import rars.simulator.Simulator;
import rars.simulator.SimulatorNotice;
import rars.venus.ExecutePane;
import rars.venus.FileStatus;
import rars.venus.GuiAction;
import rars.venus.VenusUI;
import rars.venus.run.RunGoAction;

public class RunStepAction
extends GuiAction {
    private String name;
    private ExecutePane executePane;
    private VenusUI mainUI;

    public RunStepAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke, VenusUI venusUI) {
        super(string, icon, string2, n, keyStroke);
        this.mainUI = venusUI;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.name = this.getValue("Name").toString();
        this.executePane = this.mainUI.getMainPane().getExecutePane();
        if (FileStatus.isAssembled()) {
            if (!this.mainUI.getStarted()) {
                this.processProgramArgumentsIfAny();
            }
            this.mainUI.setStarted(true);
            this.mainUI.getMessagesPane().selectRunMessageTab();
            this.executePane.getTextSegmentWindow().setCodeHighlighting(true);
            Observer observer = new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    SimulatorNotice simulatorNotice = (SimulatorNotice)object;
                    if (simulatorNotice.getAction() != 1) {
                        return;
                    }
                    EventQueue.invokeLater(() -> RunStepAction.this.stepped(simulatorNotice.getDone(), simulatorNotice.getReason(), simulatorNotice.getException()));
                    observable.deleteObserver(this);
                }
            };
            Simulator.getInstance().addObserver(observer);
            Globals.program.startSimulation(1, null);
        } else {
            JOptionPane.showMessageDialog(this.mainUI, "The program must be assembled before it can be run.");
        }
    }

    public void stepped(boolean bl, Simulator.Reason reason, SimulationException simulationException) {
        this.executePane.getRegistersWindow().updateRegisters();
        this.executePane.getFloatingPointWindow().updateRegisters();
        this.executePane.getControlAndStatusWindow().updateRegisters();
        this.executePane.getDataSegmentWindow().updateValues();
        if (!bl) {
            this.executePane.getTextSegmentWindow().highlightStepAtPC();
            FileStatus.set(5);
        }
        if (bl) {
            RunGoAction.resetMaxSteps();
            this.executePane.getTextSegmentWindow().unhighlightAllSteps();
            FileStatus.set(7);
        }
        if (bl && simulationException == null) {
            this.mainUI.getMessagesPane().postMessage("\n" + this.name + ": execution " + (reason == Simulator.Reason.CLIFF_TERMINATION ? "terminated due to null instruction." : "completed successfully.") + "\n\n");
            this.mainUI.getMessagesPane().postRunMessage("\n-- program is finished running" + (reason == Simulator.Reason.CLIFF_TERMINATION ? "(dropped off bottom)" : " (" + Globals.exitCode + ")") + " --\n\n");
            this.mainUI.getMessagesPane().selectRunMessageTab();
        }
        if (simulationException != null) {
            RunGoAction.resetMaxSteps();
            this.mainUI.getMessagesPane().postMessage(simulationException.error().generateReport());
            this.mainUI.getMessagesPane().postMessage("\n" + this.name + ": execution terminated with errors.\n\n");
            this.mainUI.getRegistersPane().setSelectedComponent(this.executePane.getControlAndStatusWindow());
            FileStatus.set(7);
            this.executePane.getTextSegmentWindow().setCodeHighlighting(true);
            this.executePane.getTextSegmentWindow().unhighlightAllSteps();
            this.executePane.getTextSegmentWindow().highlightStepAtAddress(RegisterFile.getProgramCounter() - 4);
        }
        this.mainUI.setReset(false);
    }

    private void processProgramArgumentsIfAny() {
        String string = this.executePane.getTextSegmentWindow().getProgramArguments();
        if (string == null || string.length() == 0 || !Globals.getSettings().getBooleanSetting(Settings.Bool.PROGRAM_ARGUMENTS)) {
            return;
        }
        new ProgramArgumentList(string).storeProgramArguments();
    }
}

