/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.run;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import rars.AssemblyException;
import rars.Globals;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.InterruptController;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.RegisterFile;
import rars.util.SystemIO;
import rars.venus.ExecutePane;
import rars.venus.FileStatus;
import rars.venus.GuiAction;
import rars.venus.VenusUI;
import rars.venus.run.RunAssembleAction;
import rars.venus.run.RunGoAction;

public class RunResetAction
extends GuiAction {
    private VenusUI mainUI;

    public RunResetAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke, VenusUI venusUI) {
        super(string, icon, string2, n, keyStroke);
        this.mainUI = venusUI;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        RunGoAction.resetMaxSteps();
        String string = this.getValue("Name").toString();
        ExecutePane executePane = this.mainUI.getMainPane().getExecutePane();
        try {
            Globals.program.assemble(RunAssembleAction.getProgramsToAssemble(), RunAssembleAction.getExtendedAssemblerEnabled(), RunAssembleAction.getWarningsAreErrors());
        }
        catch (AssemblyException assemblyException) {
            this.mainUI.getMessagesPane().postMessage("Unable to reset.  Please close file then re-open and re-assemble.\n");
            return;
        }
        RegisterFile.resetRegisters();
        FloatingPointRegisterFile.resetRegisters();
        ControlAndStatusRegisterFile.resetRegisters();
        InterruptController.reset();
        executePane.getRegistersWindow().clearHighlighting();
        executePane.getRegistersWindow().updateRegisters();
        executePane.getFloatingPointWindow().clearHighlighting();
        executePane.getFloatingPointWindow().updateRegisters();
        executePane.getControlAndStatusWindow().clearHighlighting();
        executePane.getControlAndStatusWindow().updateRegisters();
        executePane.getDataSegmentWindow().highlightCellForAddress(Memory.dataBaseAddress);
        executePane.getDataSegmentWindow().clearHighlighting();
        executePane.getTextSegmentWindow().resetModifiedSourceCode();
        executePane.getTextSegmentWindow().setCodeHighlighting(true);
        executePane.getTextSegmentWindow().highlightStepAtPC();
        this.mainUI.getRegistersPane().setSelectedComponent(executePane.getRegistersWindow());
        FileStatus.set(5);
        this.mainUI.setReset(true);
        this.mainUI.setStarted(false);
        SystemIO.resetFiles();
        this.mainUI.getMessagesPane().postRunMessage("\n" + string + ": reset completed.\n\n");
    }
}

