/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.run;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import rars.Globals;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.RegisterFile;
import rars.venus.ExecutePane;
import rars.venus.FileStatus;
import rars.venus.GuiAction;
import rars.venus.VenusUI;

public class RunBackstepAction
extends GuiAction {
    private String name;
    private ExecutePane executePane;
    private VenusUI mainUI;

    public RunBackstepAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke, VenusUI venusUI) {
        super(string, icon, string2, n, keyStroke);
        this.mainUI = venusUI;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.name = this.getValue("Name").toString();
        this.executePane = this.mainUI.getMainPane().getExecutePane();
        boolean bl = false;
        if (!FileStatus.isAssembled()) {
            JOptionPane.showMessageDialog(this.mainUI, "The program must be assembled before it can be run.");
            return;
        }
        this.mainUI.setStarted(true);
        this.mainUI.getMessagesPane().selectRunMessageTab();
        this.executePane.getTextSegmentWindow().setCodeHighlighting(true);
        if (Globals.getSettings().getBackSteppingEnabled()) {
            Memory.getInstance().addObserver(this.executePane.getDataSegmentWindow());
            RegisterFile.addRegistersObserver(this.executePane.getRegistersWindow());
            ControlAndStatusRegisterFile.addRegistersObserver(this.executePane.getControlAndStatusWindow());
            FloatingPointRegisterFile.addRegistersObserver(this.executePane.getFloatingPointWindow());
            Globals.program.getBackStepper().backStep();
            Memory.getInstance().deleteObserver(this.executePane.getDataSegmentWindow());
            RegisterFile.deleteRegistersObserver(this.executePane.getRegistersWindow());
            this.executePane.getRegistersWindow().updateRegisters();
            this.executePane.getFloatingPointWindow().updateRegisters();
            this.executePane.getControlAndStatusWindow().updateRegisters();
            this.executePane.getDataSegmentWindow().updateValues();
            this.executePane.getTextSegmentWindow().highlightStepAtPC();
            FileStatus.set(5);
            this.mainUI.setReset(false);
        }
    }
}

