/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.editors.jeditsyntax;

import java.util.ArrayList;

public class PopupHelpItem {
    private String tokenText;
    private String example;
    private String description;
    private boolean exact;
    private int exampleLength;
    private static final String spaces = "                                        ";

    public PopupHelpItem(String string, String string2, String string3, boolean bl) {
        int n;
        this.tokenText = string;
        this.example = string2;
        this.description = bl ? string3 : ((n = string3.indexOf(":")) == -1 ? string3 : string3.substring(0, n));
        this.exampleLength = this.example.length();
        this.exact = bl;
    }

    public PopupHelpItem(String string, String string2, String string3) {
        this(string, string2, string3, true);
    }

    public String getTokenText() {
        return this.tokenText;
    }

    public String getExample() {
        return this.example;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getExact() {
        return this.exact;
    }

    public int getExampleLength() {
        return this.exampleLength;
    }

    public String getExamplePaddedToLength(int n) {
        String string = null;
        if (n > this.exampleLength) {
            int n2 = n - this.exampleLength;
            if (n2 > spaces.length()) {
                n2 = spaces.length();
            }
            string = this.example + spaces.substring(0, n2);
        } else {
            string = n == this.exampleLength ? this.example : this.example.substring(0, n);
        }
        return string;
    }

    public void setExample(String string) {
        this.example = string;
        this.exampleLength = string.length();
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public static int maxExampleLength(ArrayList<PopupHelpItem> arrayList) {
        int n = 0;
        if (arrayList != null) {
            for (PopupHelpItem popupHelpItem : arrayList) {
                n = Math.max(n, popupHelpItem.getExampleLength());
            }
        }
        return n;
    }
}

