/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.editors.jeditsyntax;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import rars.Globals;
import rars.Settings;
import rars.venus.EditPane;
import rars.venus.editors.TextEditingArea;
import rars.venus.editors.jeditsyntax.JEditTextArea;
import rars.venus.editors.jeditsyntax.SyntaxUtilities;
import rars.venus.editors.jeditsyntax.tokenmarker.RISCVTokenMarker;

public class JEditBasedTextArea
extends JEditTextArea
implements TextEditingArea,
CaretListener {
    private final JComponent lineNumbers;
    private EditPane editPane;
    private UndoManager undoManager;
    private UndoableEditListener undoableEditListener;
    private boolean isCompoundEdit = false;
    private CompoundEdit compoundEdit;
    private JEditBasedTextArea sourceCode;

    public JEditBasedTextArea(EditPane editPane, JComponent jComponent) {
        super(jComponent);
        this.lineNumbers = jComponent;
        this.editPane = editPane;
        this.undoManager = new UndoManager();
        this.compoundEdit = new CompoundEdit();
        this.sourceCode = this;
        this.undoableEditListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                if (JEditBasedTextArea.this.isCompoundEdit) {
                    JEditBasedTextArea.this.compoundEdit.addEdit(undoableEditEvent.getEdit());
                } else {
                    JEditBasedTextArea.this.undoManager.addEdit(undoableEditEvent.getEdit());
                    JEditBasedTextArea.this.editPane.updateUndoAndRedoState();
                }
            }
        };
        this.getDocument().addUndoableEditListener(this.undoableEditListener);
        this.setFont(Globals.getSettings().getEditorFont());
        this.setTokenMarker(new RISCVTokenMarker());
        this.addCaretListener(this);
    }

    @Override
    public void setFont(Font font) {
        this.getPainter().setFont(font);
    }

    @Override
    public Font getFont() {
        return this.getPainter().getFont();
    }

    @Override
    public void setLineHighlightEnabled(boolean bl) {
        this.getPainter().setLineHighlightEnabled(bl);
    }

    @Override
    public void setCaretBlinkRate(int n) {
        if (n == 0) {
            this.caretBlinks = false;
        }
        if (n > 0) {
            this.caretBlinks = true;
            this.caretBlinkRate = n;
            caretTimer.setDelay(n);
            caretTimer.setInitialDelay(n);
            caretTimer.restart();
        }
    }

    @Override
    public void setTabSize(int n) {
        this.painter.setTabSize(n);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.getPainter().setBackground(color);
        this.lineNumbers.setOpaque(true);
        this.lineNumbers.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.getPainter().setForeground(color);
        this.lineNumbers.setForeground(color);
    }

    public void updateEditorColors() {
        boolean bl = this.isEditable();
        Settings settings = Globals.getSettings();
        Color color = settings.getColorSettingByPosition(12);
        Color color2 = settings.getColorSettingByPosition(13);
        this.setBackground(bl ? color : color.darker());
        this.getPainter().setLineHighlightColor(settings.getColorSettingByPosition(14));
        this.getPainter().setSelectionColor(settings.getColorSettingByPosition(15));
        this.getPainter().setCaretColor(settings.getColorSettingByPosition(16));
        this.setForeground(bl ? color2 : color2.darker());
    }

    @Override
    public void updateSyntaxStyles() {
        this.updateEditorColors();
        this.painter.setStyles(SyntaxUtilities.getCurrentSyntaxStyles());
    }

    @Override
    public Component getOuterComponent() {
        return this;
    }

    @Override
    public void discardAllUndoableEdits() {
        this.undoManager.discardAllEdits();
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.editPane.displayCaretPosition(((JEditTextArea.MutableCaretEvent)caretEvent).getDot());
    }

    @Override
    public void replaceSelection(String string) {
        this.setSelectedText(string);
    }

    @Override
    public void setSelectionVisible(boolean bl) {
    }

    @Override
    public void setSourceCode(String string, boolean bl) {
        this.setText(string);
        this.setEditable(bl);
        this.setEnabled(bl);
        this.setCaretPosition(0);
        this.updateEditorColors();
        if (bl) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void undo() {
        this.unredoing = true;
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            System.out.println("Unable to undo: " + cannotUndoException);
            cannotUndoException.printStackTrace();
        }
        this.unredoing = false;
        this.setCaretVisible(true);
    }

    @Override
    public void redo() {
        this.unredoing = true;
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            System.out.println("Unable to redo: " + cannotRedoException);
            cannotRedoException.printStackTrace();
        }
        this.unredoing = false;
        this.setCaretVisible(true);
    }

    @Override
    public int doFindText(String string, boolean bl) {
        int n = this.sourceCode.getCaretPosition();
        int n2 = 0;
        n2 = this.nextIndex(this.sourceCode.getText(), string, n, bl);
        if (n2 >= 0) {
            this.sourceCode.requestFocus();
            this.sourceCode.setSelectionStart(n2);
            this.sourceCode.setSelectionEnd(n2 + string.length());
            this.sourceCode.setSelectionStart(n2);
            return 1;
        }
        return 0;
    }

    public int nextIndex(String string, String string2, int n, boolean bl) {
        int n2 = -1;
        if (string != null && string2 != null && n < string.length()) {
            if (bl) {
                n2 = string.indexOf(string2, n);
                if (n > 0 && n2 < 0) {
                    n2 = string.indexOf(string2);
                }
            } else {
                String string3 = string.toLowerCase();
                n2 = string3.indexOf(string2.toLowerCase(), n);
                if (n > 0 && n2 < 0) {
                    n2 = string3.indexOf(string2.toLowerCase());
                }
            }
        }
        return n2;
    }

    @Override
    public int doReplace(String string, String string2, boolean bl) {
        int n = 0;
        if (string == null || !string.equals(this.sourceCode.getSelectedText()) || this.sourceCode.getSelectionEnd() != this.sourceCode.getCaretPosition()) {
            return this.doFindText(string, bl);
        }
        n = this.sourceCode.getSelectionStart();
        this.sourceCode.grabFocus();
        this.sourceCode.setSelectionStart(n);
        this.sourceCode.setSelectionEnd(n + string.length());
        this.sourceCode.setSelectionStart(n);
        this.isCompoundEdit = true;
        this.compoundEdit = new CompoundEdit();
        this.sourceCode.replaceSelection(string2);
        this.compoundEdit.end();
        this.undoManager.addEdit(this.compoundEdit);
        this.editPane.updateUndoAndRedoState();
        this.isCompoundEdit = false;
        this.sourceCode.setCaretPosition(n + string2.length());
        if (this.doFindText(string, bl) == 0) {
            return 3;
        }
        return 2;
    }

    @Override
    public int doReplaceAll(String string, String string2, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.compoundEdit = null;
        this.isCompoundEdit = true;
        while (n >= 0) {
            n = this.nextIndex(this.sourceCode.getText(), string, n2, bl);
            if (n < 0) continue;
            if (n < n2) break;
            this.sourceCode.grabFocus();
            this.sourceCode.setSelectionStart(n);
            this.sourceCode.setSelectionEnd(n + string.length());
            this.sourceCode.setSelectionStart(n);
            if (this.compoundEdit == null) {
                this.compoundEdit = new CompoundEdit();
            }
            this.sourceCode.replaceSelection(string2);
            n2 = n + string2.length();
            ++n3;
        }
        this.isCompoundEdit = false;
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undoManager.addEdit(this.compoundEdit);
            this.editPane.updateUndoAndRedoState();
        }
        return n3;
    }
}

