/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.io.File;
import rars.Globals;

public class FileStatus {
    public static final int NO_FILE = 0;
    public static final int NEW_NOT_EDITED = 1;
    public static final int NEW_EDITED = 2;
    public static final int NOT_EDITED = 3;
    public static final int EDITED = 4;
    public static final int RUNNABLE = 5;
    public static final int RUNNING = 6;
    public static final int TERMINATED = 7;
    public static final int OPENING = 8;
    private static int systemStatus;
    private static boolean systemAssembled;
    private static boolean systemSaved;
    private static boolean systemEdited;
    private static String systemName;
    private static File systemFile;
    private int status;
    private File file;

    public static void set(int n) {
        systemStatus = n;
        Globals.getGui().setMenuState(systemStatus);
    }

    public static int get() {
        return systemStatus;
    }

    public static void setAssembled(boolean bl) {
        systemAssembled = bl;
    }

    public static void setSaved(boolean bl) {
        systemSaved = bl;
    }

    public static void setEdited(boolean bl) {
        systemEdited = bl;
    }

    public static void setName(String string) {
        systemName = string;
    }

    public static void setFile(File file) {
        systemFile = file;
    }

    public static File getFile() {
        return systemFile;
    }

    public static String getName() {
        return systemName;
    }

    public static boolean isAssembled() {
        return systemAssembled;
    }

    public static boolean isSaved() {
        return systemSaved;
    }

    public static boolean isEdited() {
        return systemEdited;
    }

    public static void reset() {
        systemStatus = 0;
        systemName = "";
        systemAssembled = false;
        systemSaved = false;
        systemEdited = false;
        systemFile = null;
    }

    public FileStatus() {
        this(0, null);
    }

    public FileStatus(int n, String string) {
        this.status = n;
        if (string == null) {
            this.file = null;
        } else {
            this.setPathname(string);
        }
    }

    public void setFileStatus(int n) {
        this.status = n;
    }

    public int getFileStatus() {
        return this.status;
    }

    public boolean isNew() {
        return this.status == 1 || this.status == 2;
    }

    public boolean hasUnsavedEdits() {
        return this.status == 2 || this.status == 4;
    }

    public void setPathname(String string) {
        this.file = new File(string);
    }

    public void setPathname(String string, String string2) {
        this.file = new File(string, string2);
    }

    public String getPathname() {
        return this.file == null ? null : this.file.getPath();
    }

    public String getFilename() {
        return this.file == null ? null : this.file.getName();
    }

    public String getParent() {
        return this.file == null ? null : this.file.getParent();
    }

    public void updateStaticFileStatus() {
        systemStatus = this.status;
        systemName = this.file.getPath();
        systemAssembled = false;
        systemSaved = this.status == 3 || this.status == 5 || this.status == 6 || this.status == 7;
        systemEdited = this.status == 2 || this.status == 4;
        systemFile = this.file;
    }
}

