/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import rars.AssemblyException;
import rars.Globals;
import rars.RISCVprogram;
import rars.Settings;
import rars.riscv.hardware.RegisterFile;
import rars.util.FilenameFinder;
import rars.venus.EditPane;
import rars.venus.Editor;
import rars.venus.FileStatus;
import rars.venus.MainPane;
import rars.venus.VenusUI;

public class EditTabbedPane
extends JTabbedPane {
    EditPane editTab;
    MainPane mainPane;
    private VenusUI mainUI;
    private Editor editor;
    private FileOpener fileOpener;

    public EditTabbedPane(VenusUI venusUI, Editor editor, MainPane mainPane) {
        this.mainUI = venusUI;
        this.editor = editor;
        this.fileOpener = new FileOpener(editor);
        this.mainPane = mainPane;
        this.editor.setEditTabbedPane(this);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EditPane editPane = (EditPane)EditTabbedPane.this.getSelectedComponent();
                if (editPane != null) {
                    if (Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_ALL)) {
                        EditTabbedPane.this.updateTitles(editPane);
                    } else {
                        EditTabbedPane.this.updateTitlesAndMenuState(editPane);
                        EditTabbedPane.this.mainPane.getExecutePane().clearPane();
                    }
                    editPane.tellEditingComponentToRequestFocusInWindow();
                }
            }
        });
    }

    public EditPane getCurrentEditTab() {
        return (EditPane)this.getSelectedComponent();
    }

    public void setCurrentEditTab(EditPane editPane) {
        this.setSelectedComponent(editPane);
    }

    public EditPane getCurrentEditTabForFile(File file) {
        EditPane editPane = null;
        EditPane editPane2 = this.getEditPaneForFile(file.getPath());
        if (editPane2 != null) {
            if (editPane2 != this.getCurrentEditTab()) {
                this.setCurrentEditTab(editPane2);
            }
            return editPane2;
        }
        if (this.openFile(file)) {
            editPane = this.getCurrentEditTab();
        }
        return editPane;
    }

    public void newFile() {
        EditPane editPane = new EditPane(this.mainUI);
        editPane.setSourceCode("", true);
        editPane.setShowLineNumbersEnabled(true);
        editPane.setFileStatus(1);
        String string = this.editor.getNextDefaultFilename();
        editPane.setPathname(string);
        this.addTab(string, editPane);
        FileStatus.reset();
        FileStatus.setName(string);
        FileStatus.set(1);
        RegisterFile.resetRegisters();
        this.mainUI.setReset(true);
        this.mainPane.getExecutePane().clearPane();
        this.mainPane.setSelectedComponent(this);
        editPane.displayCaretPosition(new Point(1, 1));
        this.setSelectedComponent(editPane);
        this.updateTitlesAndMenuState(editPane);
        editPane.tellEditingComponentToRequestFocusInWindow();
    }

    public boolean openFile() {
        return this.fileOpener.openFile();
    }

    public boolean openFile(File file) {
        return this.fileOpener.openFile(file);
    }

    public boolean closeCurrentFile() {
        EditPane editPane = this.getCurrentEditTab();
        if (editPane != null) {
            if (this.editsSavedOrAbandoned()) {
                this.remove(editPane);
                this.mainPane.getExecutePane().clearPane();
                this.mainPane.setSelectedComponent(this);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean closeAllFiles() {
        boolean bl = true;
        boolean bl2 = false;
        int n = this.getTabCount();
        if (n > 0) {
            int n2;
            this.mainPane.getExecutePane().clearPane();
            this.mainPane.setSelectedComponent(this);
            EditPane[] editPaneArray = new EditPane[n];
            for (n2 = 0; n2 < n; ++n2) {
                editPaneArray[n2] = (EditPane)this.getComponentAt(n2);
                if (!editPaneArray[n2].hasUnsavedEdits()) continue;
                bl2 = true;
            }
            if (bl2) {
                switch (this.confirm("one or more files")) {
                    case 0: {
                        n2 = 1;
                        for (int i = 0; i < n; ++i) {
                            if (editPaneArray[i].hasUnsavedEdits()) {
                                this.setSelectedComponent(editPaneArray[i]);
                                boolean bl3 = this.saveCurrentFile();
                                if (bl3) {
                                    this.remove(editPaneArray[i]);
                                    continue;
                                }
                                n2 = 0;
                                continue;
                            }
                            this.remove(editPaneArray[i]);
                        }
                        return n2 != 0;
                    }
                    case 1: {
                        for (int i = 0; i < n; ++i) {
                            this.remove(editPaneArray[i]);
                        }
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                }
                return false;
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.remove(editPaneArray[n2]);
            }
        }
        return bl;
    }

    public boolean saveCurrentFile() {
        EditPane editPane = this.getCurrentEditTab();
        if (this.saveFile(editPane)) {
            FileStatus.setSaved(true);
            FileStatus.setEdited(false);
            FileStatus.set(3);
            editPane.setFileStatus(3);
            this.updateTitlesAndMenuState(editPane);
            return true;
        }
        return false;
    }

    private boolean saveFile(EditPane editPane) {
        if (editPane != null) {
            if (editPane.isNew()) {
                File file = this.saveAsFile(editPane);
                if (file != null) {
                    editPane.setPathname(file.getPath());
                }
                return file != null;
            }
            File file = new File(editPane.getPathname());
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(editPane.getSource(), 0, editPane.getSource().length());
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Save operation could not be completed due to an error:\n" + iOException, "Save Operation Failed", 0);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean saveAsCurrentFile() {
        EditPane editPane = this.getCurrentEditTab();
        File file = this.saveAsFile(editPane);
        if (file != null) {
            FileStatus.setFile(file);
            FileStatus.setName(file.getPath());
            FileStatus.setSaved(true);
            FileStatus.setEdited(false);
            FileStatus.set(3);
            this.editor.setCurrentSaveDirectory(file.getParent());
            editPane.setPathname(file.getPath());
            editPane.setFileStatus(3);
            this.updateTitlesAndMenuState(editPane);
            return true;
        }
        return false;
    }

    private File saveAsFile(EditPane editPane) {
        File file = null;
        if (editPane != null) {
            Object object;
            JFileChooser jFileChooser = null;
            boolean bl = false;
            block7: while (!bl) {
                jFileChooser = editPane.isNew() ? new JFileChooser(this.editor.getCurrentSaveDirectory()) : ((object = new File(editPane.getPathname())) != null ? new JFileChooser(((File)object).getParent()) : new JFileChooser(this.editor.getCurrentSaveDirectory()));
                object = editPane.getFilename();
                if (object != null) {
                    jFileChooser.setSelectedFile(new File((String)object));
                }
                jFileChooser.setDialogTitle("Save As");
                int n = jFileChooser.showSaveDialog(this.mainUI);
                if (n != 0) {
                    return null;
                }
                file = jFileChooser.getSelectedFile();
                bl = true;
                if (!file.exists()) continue;
                int n2 = JOptionPane.showConfirmDialog(this.mainUI, "File " + file.getName() + " already exists.  Do you wish to overwrite it?", "Overwrite existing file?", 1, 2);
                switch (n2) {
                    case 0: {
                        bl = true;
                        continue block7;
                    }
                    case 1: {
                        bl = false;
                        continue block7;
                    }
                    case 2: {
                        return null;
                    }
                }
                return null;
            }
            try {
                object = new BufferedWriter(new FileWriter(file));
                ((BufferedWriter)object).write(editPane.getSource(), 0, editPane.getSource().length());
                ((BufferedWriter)object).close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Save As operation could not be completed due to an error:\n" + iOException, "Save As Operation Failed", 0);
                return null;
            }
        }
        return file;
    }

    public boolean saveAllFiles() {
        boolean bl = false;
        int n = this.getTabCount();
        if (n > 0) {
            bl = true;
            EditPane[] editPaneArray = new EditPane[n];
            EditPane editPane = this.getCurrentEditTab();
            for (int i = 0; i < n; ++i) {
                editPaneArray[i] = (EditPane)this.getComponentAt(i);
                if (!editPaneArray[i].hasUnsavedEdits()) continue;
                this.setCurrentEditTab(editPaneArray[i]);
                if (this.saveFile(editPaneArray[i])) {
                    editPaneArray[i].setFileStatus(3);
                    this.editor.setTitle(editPaneArray[i].getPathname(), editPaneArray[i].getFilename(), editPaneArray[i].getFileStatus());
                    continue;
                }
                bl = false;
            }
            this.setCurrentEditTab(editPane);
            if (bl) {
                EditPane editPane2 = this.getCurrentEditTab();
                FileStatus.setSaved(true);
                FileStatus.setEdited(false);
                FileStatus.set(3);
                editPane2.setFileStatus(3);
                this.updateTitlesAndMenuState(editPane2);
            }
        }
        return bl;
    }

    public String[] getOpenFilePaths() {
        int n = this.getTabCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((EditPane)this.getComponentAt(i)).getPathname();
        }
        return stringArray;
    }

    public void remove(EditPane editPane) {
        super.remove(editPane);
        editPane = this.getCurrentEditTab();
        if (editPane == null) {
            FileStatus.set(0);
            this.editor.setTitle("", "", 0);
            Globals.getGui().setMenuState(0);
        } else {
            FileStatus.set(editPane.getFileStatus());
            this.updateTitlesAndMenuState(editPane);
        }
        if (this.getTabCount() == 0) {
            this.mainUI.haveMenuRequestFocus();
        }
    }

    private void updateTitlesAndMenuState(EditPane editPane) {
        this.editor.setTitle(editPane.getPathname(), editPane.getFilename(), editPane.getFileStatus());
        editPane.updateStaticFileStatus();
        Globals.getGui().setMenuState(editPane.getFileStatus());
    }

    private void updateTitles(EditPane editPane) {
        this.editor.setTitle(editPane.getPathname(), editPane.getFilename(), editPane.getFileStatus());
        boolean bl = FileStatus.isAssembled();
        editPane.updateStaticFileStatus();
        FileStatus.setAssembled(bl);
    }

    public EditPane getEditPaneForFile(String string) {
        EditPane editPane = null;
        for (int i = 0; i < this.getTabCount(); ++i) {
            EditPane editPane2 = (EditPane)this.getComponentAt(i);
            if (!editPane2.getPathname().equals(string)) continue;
            editPane = editPane2;
            break;
        }
        return editPane;
    }

    public boolean editsSavedOrAbandoned() {
        EditPane editPane = this.getCurrentEditTab();
        if (editPane != null && editPane.hasUnsavedEdits()) {
            switch (this.confirm(editPane.getFilename())) {
                case 0: {
                    return this.saveCurrentFile();
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private int confirm(String string) {
        return JOptionPane.showConfirmDialog(this.mainUI, "Changes to " + string + " will be lost unless you save.  Do you wish to save all changes now?", "Save program changes?", 1, 2);
    }

    private class FileOpener {
        private File mostRecentlyOpenedFile = null;
        private JFileChooser fileChooser;
        private int fileFilterCount;
        private ArrayList<FileFilter> fileFilterList;
        private PropertyChangeListener listenForUserAddedFileFilter;
        private Editor theEditor;

        public FileOpener(Editor editor) {
            this.theEditor = editor;
            this.fileChooser = new JFileChooser();
            this.listenForUserAddedFileFilter = new ChoosableFileFilterChangeListener();
            this.fileChooser.addPropertyChangeListener(this.listenForUserAddedFileFilter);
            this.fileFilterList = new ArrayList();
            this.fileFilterList.add(this.fileChooser.getAcceptAllFileFilter());
            this.fileFilterList.add(FilenameFinder.getFileFilter(Globals.fileExtensions, "Assembler Files", true));
            this.fileFilterCount = 0;
            this.setChoosableFileFilters();
        }

        private boolean openFile() {
            this.setChoosableFileFilters();
            this.fileChooser.setCurrentDirectory(new File(this.theEditor.getCurrentOpenDirectory()));
            if (Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_ON_OPEN) && this.mostRecentlyOpenedFile != null) {
                this.fileChooser.setSelectedFile(this.mostRecentlyOpenedFile);
            }
            if (this.fileChooser.showOpenDialog(EditTabbedPane.this.mainUI) == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.theEditor.setCurrentOpenDirectory(file.getParent());
                if (!this.openFile(file)) {
                    return false;
                }
                if (file.canRead() && Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_ON_OPEN)) {
                    EditTabbedPane.this.mainUI.getRunAssembleAction().actionPerformed(null);
                }
            }
            return true;
        }

        private boolean openFile(File file) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string = file.getPath();
            EditPane editPane = EditTabbedPane.this.getEditPaneForFile(string);
            if (editPane != null) {
                EditTabbedPane.this.setSelectedComponent(editPane);
                EditTabbedPane.this.updateTitles(editPane);
                return false;
            }
            editPane = new EditPane(EditTabbedPane.this.mainUI);
            editPane.setPathname(string);
            FileStatus.setName(string);
            FileStatus.setFile(file);
            FileStatus.set(8);
            if (file.canRead()) {
                Globals.program = new RISCVprogram();
                try {
                    Globals.program.readSource(string);
                }
                catch (AssemblyException assemblyException) {
                    // empty catch block
                }
                StringBuffer stringBuffer = new StringBuffer((int)file.length());
                int n = 1;
                String string2 = Globals.program.getSourceLine(n++);
                while (string2 != null) {
                    stringBuffer.append(string2 + "\n");
                    string2 = Globals.program.getSourceLine(n++);
                }
                editPane.setSourceCode(stringBuffer.toString(), true);
                editPane.discardAllUndoableEdits();
                editPane.setShowLineNumbersEnabled(true);
                editPane.setFileStatus(3);
                EditTabbedPane.this.addTab(editPane.getFilename(), editPane);
                EditTabbedPane.this.setToolTipTextAt(EditTabbedPane.this.indexOfComponent(editPane), editPane.getPathname());
                EditTabbedPane.this.setSelectedComponent(editPane);
                FileStatus.setSaved(true);
                FileStatus.setEdited(false);
                FileStatus.set(3);
                if (Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_ALL)) {
                    EditTabbedPane.this.updateTitles(editPane);
                } else {
                    EditTabbedPane.this.updateTitlesAndMenuState(editPane);
                    EditTabbedPane.this.mainPane.getExecutePane().clearPane();
                }
                EditTabbedPane.this.mainPane.setSelectedComponent(EditTabbedPane.this);
                editPane.tellEditingComponentToRequestFocusInWindow();
                this.mostRecentlyOpenedFile = file;
            }
            return true;
        }

        private void setChoosableFileFilters() {
            if (this.fileFilterCount < this.fileFilterList.size() || this.fileFilterList.size() != this.fileChooser.getChoosableFileFilters().length) {
                this.fileFilterCount = this.fileFilterList.size();
                boolean bl = false;
                if (this.fileChooser.getPropertyChangeListeners().length > 0) {
                    this.fileChooser.removePropertyChangeListener(this.listenForUserAddedFileFilter);
                    bl = true;
                }
                this.fileChooser.resetChoosableFileFilters();
                for (FileFilter fileFilter : this.fileFilterList) {
                    this.fileChooser.addChoosableFileFilter(fileFilter);
                }
                if (bl) {
                    this.fileChooser.addPropertyChangeListener(this.listenForUserAddedFileFilter);
                }
            }
        }

        private class ChoosableFileFilterChangeListener
        implements PropertyChangeListener {
            private ChoosableFileFilterChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "ChoosableFileFilterChangedProperty") {
                    FileFilter[] fileFilterArray = (FileFilter[])propertyChangeEvent.getNewValue();
                    FileFilter[] fileFilterArray2 = (FileFilter[])propertyChangeEvent.getOldValue();
                    if (fileFilterArray.length > FileOpener.this.fileFilterList.size()) {
                        FileOpener.this.fileFilterList.add(fileFilterArray[fileFilterArray.length - 1]);
                    }
                }
            }
        }
    }
}

