/*
 * Decompiled with CFR 0.152.
 */
package rars.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.filechooser.FileFilter;

public class FilenameFinder {
    private static final String JAR_EXTENSION = ".jar";
    private static final String FILE_URL = "file:";
    private static final String JAR_URI_PREFIX = "jar:";
    private static final boolean NO_DIRECTORIES = false;
    public static String MATCH_ALL_EXTENSIONS = "*";

    public static ArrayList<String> getFilenameList(ClassLoader classLoader, String string, String string2) {
        string2 = FilenameFinder.checkFileExtension(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                File file;
                File[] fileArray;
                URI uRI = new URI(enumeration.nextElement().toString());
                if (uRI.toString().indexOf(JAR_URI_PREFIX) == 0) {
                    uRI = new URI(uRI.toString().substring(JAR_URI_PREFIX.length()));
                }
                if ((fileArray = (file = new File(uRI.getPath())).listFiles()) == null) {
                    if (file.toString().toLowerCase().indexOf(JAR_EXTENSION) <= 0) continue;
                    arrayList.addAll(FilenameFinder.getListFromJar(FilenameFinder.extractJarFilename(file.toString()), string, string2));
                    continue;
                }
                FileFilter fileFilter = FilenameFinder.getFileFilter(string2, "", false);
                for (File file2 : fileArray) {
                    if (!fileFilter.accept(file2)) continue;
                    arrayList.add(file2.getName());
                }
            }
            return arrayList;
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return arrayList;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return arrayList;
        }
    }

    public static ArrayList<String> getFilenameList(ClassLoader classLoader, String string, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList();
        if (arrayList == null || arrayList.size() == 0) {
            arrayList2 = FilenameFinder.getFilenameList(classLoader, string, "");
        } else {
            for (String string2 : arrayList) {
                arrayList2.addAll(FilenameFinder.getFilenameList(classLoader, string, string2));
            }
        }
        return arrayList2;
    }

    public static ArrayList<String> getFilenameList(String string, String string2) {
        string2 = FilenameFinder.checkFileExtension(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            FileFilter fileFilter = FilenameFinder.getFileFilter(string2, "", false);
            for (File file2 : fileArray) {
                if (!fileFilter.accept(file2)) continue;
                arrayList.add(file2.getAbsolutePath());
            }
        }
        return arrayList;
    }

    public static ArrayList<String> getFilenameList(String string, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList();
        if (arrayList == null || arrayList.size() == 0) {
            arrayList2 = FilenameFinder.getFilenameList(string, "");
        } else {
            for (String string2 : arrayList) {
                arrayList2.addAll(FilenameFinder.getFilenameList(string, string2));
            }
        }
        return arrayList2;
    }

    public static ArrayList<String> getFilenameList(ArrayList<String> arrayList, String string) {
        string = FilenameFinder.checkFileExtension(string);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        FileFilter fileFilter = FilenameFinder.getFileFilter(string, "", false);
        for (String string2 : arrayList) {
            File file = new File(string2);
            if (!fileFilter.accept(file)) continue;
            arrayList2.add(file.getAbsolutePath());
        }
        return arrayList2;
    }

    public static ArrayList<String> getFilenameList(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<String> arrayList3 = new ArrayList();
        if (arrayList2 == null || arrayList2.size() == 0) {
            arrayList3 = FilenameFinder.getFilenameList(arrayList, "");
        } else {
            for (String string : arrayList2) {
                String string2 = FilenameFinder.checkFileExtension(string);
                arrayList3.addAll(FilenameFinder.getFilenameList(arrayList, string2));
            }
        }
        return arrayList3;
    }

    public static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public static FileFilter getFileFilter(ArrayList<String> arrayList, String string, boolean bl) {
        return new RarsFileFilter(arrayList, string, bl);
    }

    public static FileFilter getFileFilter(String string, String string2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return new RarsFileFilter(arrayList, string2, bl);
    }

    public static boolean fileExtensionMatch(String string, String string2) {
        return string2 == null || string2.length() == 0 || string.endsWith((string2.startsWith(".") ? "" : ".") + string2);
    }

    private static ArrayList<String> getListFromJar(String string, String string2, String string3) {
        string3 = FilenameFinder.checkFileExtension(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        try {
            ZipFile zipFile = new ZipFile(new File(string));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().startsWith(string2 + "/") || !FilenameFinder.fileExtensionMatch(zipEntry.getName(), string3)) continue;
                arrayList.add(zipEntry.getName().substring(zipEntry.getName().lastIndexOf(47) + 1));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occurred reading Filename list from JAR: " + exception);
        }
        return arrayList;
    }

    private static String extractJarFilename(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
        if (string.toLowerCase().startsWith(FILE_URL)) {
            string = string.substring(FILE_URL.length());
        }
        return (n = string.toLowerCase().lastIndexOf(JAR_EXTENSION)) >= 0 ? string.substring(0, n + JAR_EXTENSION.length()) : string;
    }

    private static String checkFileExtension(String string) {
        return string == null || string.length() == 0 || !string.startsWith(".") ? string : string.substring(1);
    }

    private static class RarsFileFilter
    extends FileFilter {
        private ArrayList<String> extensions;
        private String fullDescription;
        private boolean acceptDirectories;

        private RarsFileFilter(ArrayList<String> arrayList, String string, boolean bl) {
            this.extensions = arrayList;
            this.fullDescription = this.buildFullDescription(string, arrayList);
            this.acceptDirectories = bl;
        }

        private String buildFullDescription(String string, ArrayList<String> arrayList) {
            String string2;
            String string3 = string2 = string == null ? "" : string;
            if (arrayList.size() > 0) {
                string2 = string2 + "  (";
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                String string4 = arrayList.get(i);
                if (string4 == null || string4.length() <= 0) continue;
                string2 = string2 + (i == 0 ? "" : "; ") + "*" + (string4.charAt(0) == '.' ? "" : ".") + string4;
            }
            if (arrayList.size() > 0) {
                string2 = string2 + ")";
            }
            return string2;
        }

        @Override
        public String getDescription() {
            return this.fullDescription;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return this.acceptDirectories;
            }
            String string = FilenameFinder.getExtension(file);
            if (string != null) {
                for (String string2 : this.extensions) {
                    String string3 = FilenameFinder.checkFileExtension(string2);
                    if (!string3.equals(MATCH_ALL_EXTENSIONS) && !string.equals(string3)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

