/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Observable;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import rars.Globals;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.Register;
import rars.tools.AbstractToolAndApplication;
import rars.util.Binary;

public class FloatRepresentation
extends AbstractToolAndApplication {
    private static String version = "Version 1.1";
    private static String heading = "32-bit IEEE 754 Floating Point Representation";
    private static final String title = "Floating Point Representation, ";
    private static final String defaultHex = "00000000";
    private static final String defaultDecimal = "0.0";
    private static final String defaultBinarySign = "0";
    private static final String defaultBinaryExponent = "00000000";
    private static final String defaultBinaryFraction = "00000000000000000000000";
    private static final int maxLengthHex = 8;
    private static final int maxLengthBinarySign = 1;
    private static final int maxLengthBinaryExponent = 8;
    private static final int maxLengthBinaryFraction = 23;
    private static final int maxLengthBinaryTotal = 32;
    private static final int maxLengthDecimal = 20;
    private static final String denormalizedLabel = "                 significand (denormalized - no 'hidden bit')";
    private static final String normalizedLabel = "                 significand ('hidden bit' underlined)       ";
    private static final Font instructionsFont = new Font("Arial", 0, 14);
    private static final Font hexDisplayFont = new Font("Courier", 0, 32);
    private static final Font binaryDisplayFont = new Font("Courier", 0, 18);
    private static final Font decimalDisplayFont = new Font("Courier", 0, 18);
    private static final Color hexDisplayColor = Color.red;
    private static final Color binaryDisplayColor = Color.black;
    private static final Color decimalDisplayColor = Color.blue;
    private static final String expansionFontTag = "<font size=\"+1\" face=\"Courier\" color=\"#000000\">";
    private static final String instructionFontTag = "<font size=\"+0\" face=\"Verdana, Arial, Helvetica\" color=\"#000000\">";
    private static final int exponentBias = 127;
    private Register attachedRegister = null;
    private Register[] fpRegisters;
    private JPanel binarySignDecoratedDisplay;
    private JPanel binaryExponentDecoratedDisplay;
    private JPanel binaryFractionDecoratedDisplay;
    private JTextField hexDisplay;
    private JTextField decimalDisplay;
    private JTextField binarySignDisplay;
    private JTextField binaryExponentDisplay;
    private JTextField binaryFractionDisplay;
    private JLabel expansionDisplay;
    private JLabel significandLabel = new JLabel("                 significand (denormalized - no 'hidden bit')", 0);
    private BinaryToDecimalFormulaGraphic binaryToDecimalFormulaGraphic;
    private InstructionsPane instructions;
    private String defaultInstructions = "Modify any value then press the Enter key to update all values.";
    private static final String zeroes = "0000000000000000000000000000000000000000000000000000000000000000";
    private static final String HTMLspaces = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    public FloatRepresentation(String string, String string2) {
        super(string, string2);
    }

    public FloatRepresentation() {
        this(title + version, heading);
    }

    public static void main(String[] stringArray) {
        new FloatRepresentation(title + version, heading).go();
    }

    @Override
    public String getName() {
        return "Floating Point Representation";
    }

    @Override
    protected void addAsObserver() {
        this.addAsObserver(this.attachedRegister);
    }

    @Override
    protected void deleteAsObserver() {
        this.deleteAsObserver(this.attachedRegister);
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        return this.buildDisplayArea();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (((AccessNotice)object).getAccessType() == 1) {
            this.updateDisplays(new FlavorsOfFloat().buildOneFromInt((int)this.attachedRegister.getValue()));
        }
    }

    @Override
    protected void reset() {
        this.instructions.setText(this.defaultInstructions);
        this.updateDisplaysAndRegister(new FlavorsOfFloat());
    }

    protected JComponent buildDisplayArea() {
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(5, 1, 0, 0));
        Box box2 = Box.createHorizontalBox();
        box2.add(jPanel);
        box2.add(jPanel2);
        box.add(box2);
        this.hexDisplay = new JTextField("00000000", 9);
        this.hexDisplay.setFont(hexDisplayFont);
        this.hexDisplay.setForeground(hexDisplayColor);
        this.hexDisplay.setHorizontalAlignment(4);
        this.hexDisplay.setToolTipText("8-digit hexadecimal (base 16) display");
        this.hexDisplay.setEditable(true);
        this.hexDisplay.revalidate();
        this.hexDisplay.addKeyListener(new HexDisplayKeystrokeListener(8));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.hexDisplay);
        jPanel.add(jPanel3);
        HexToBinaryGraphicPanel hexToBinaryGraphicPanel = new HexToBinaryGraphicPanel();
        jPanel.add(hexToBinaryGraphicPanel);
        this.binarySignDisplay = new JTextField(defaultBinarySign, 2);
        this.binarySignDisplay.setFont(binaryDisplayFont);
        this.binarySignDisplay.setForeground(binaryDisplayColor);
        this.binarySignDisplay.setHorizontalAlignment(4);
        this.binarySignDisplay.setToolTipText("The sign bit");
        this.binarySignDisplay.setEditable(true);
        this.binarySignDisplay.revalidate();
        this.binaryExponentDisplay = new JTextField("00000000", 9);
        this.binaryExponentDisplay.setFont(binaryDisplayFont);
        this.binaryExponentDisplay.setForeground(binaryDisplayColor);
        this.binaryExponentDisplay.setHorizontalAlignment(4);
        this.binaryExponentDisplay.setToolTipText("8-bit exponent");
        this.binaryExponentDisplay.setEditable(true);
        this.binaryExponentDisplay.revalidate();
        this.binaryFractionDisplay = new BinaryFractionDisplayTextField(defaultBinaryFraction, 24);
        this.binaryFractionDisplay.setFont(binaryDisplayFont);
        this.binaryFractionDisplay.setForeground(binaryDisplayColor);
        this.binaryFractionDisplay.setHorizontalAlignment(4);
        this.binaryFractionDisplay.setToolTipText("23-bit fraction");
        this.binaryFractionDisplay.setEditable(true);
        this.binaryFractionDisplay.revalidate();
        this.binarySignDisplay.addKeyListener(new BinaryDisplayKeystrokeListener(1));
        this.binaryExponentDisplay.addKeyListener(new BinaryDisplayKeystrokeListener(8));
        this.binaryFractionDisplay.addKeyListener(new BinaryDisplayKeystrokeListener(23));
        JPanel jPanel4 = new JPanel();
        this.binarySignDecoratedDisplay = new JPanel(new BorderLayout());
        this.binaryExponentDecoratedDisplay = new JPanel(new BorderLayout());
        this.binaryFractionDecoratedDisplay = new JPanel(new BorderLayout());
        this.binarySignDecoratedDisplay.add((Component)this.binarySignDisplay, "Center");
        this.binarySignDecoratedDisplay.add((Component)new JLabel("sign", 0), "South");
        this.binaryExponentDecoratedDisplay.add((Component)this.binaryExponentDisplay, "Center");
        this.binaryExponentDecoratedDisplay.add((Component)new JLabel("exponent", 0), "South");
        this.binaryFractionDecoratedDisplay.add((Component)this.binaryFractionDisplay, "Center");
        this.binaryFractionDecoratedDisplay.add((Component)new JLabel("fraction", 0), "South");
        jPanel4.add(this.binarySignDecoratedDisplay);
        jPanel4.add(this.binaryExponentDecoratedDisplay);
        jPanel4.add(this.binaryFractionDecoratedDisplay);
        jPanel.add(jPanel4);
        this.binaryToDecimalFormulaGraphic = new BinaryToDecimalFormulaGraphic();
        this.binaryToDecimalFormulaGraphic.setBackground(jPanel.getBackground());
        jPanel.add(this.binaryToDecimalFormulaGraphic);
        this.expansionDisplay = new JLabel((FloatRepresentation)this.new FlavorsOfFloat().expansionString);
        this.expansionDisplay.setFont(new Font("Monospaced", 0, 12));
        this.expansionDisplay.setFocusable(false);
        this.expansionDisplay.setBackground(jPanel.getBackground());
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        jPanel5.add(this.expansionDisplay);
        jPanel5.add(this.significandLabel);
        jPanel.add(jPanel5);
        this.decimalDisplay = new JTextField(defaultDecimal, 21);
        this.decimalDisplay.setFont(decimalDisplayFont);
        this.decimalDisplay.setForeground(decimalDisplayColor);
        this.decimalDisplay.setHorizontalAlignment(4);
        this.decimalDisplay.setToolTipText("Decimal floating point value");
        this.decimalDisplay.setMargin(new Insets(0, 0, 0, 0));
        this.decimalDisplay.setEditable(true);
        this.decimalDisplay.revalidate();
        this.decimalDisplay.addKeyListener(new DecimalDisplayKeystokeListenter());
        Box box3 = Box.createVerticalBox();
        box3.add(Box.createVerticalStrut(5));
        box3.add(this.decimalDisplay);
        box3.add(Box.createVerticalStrut(15));
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel jPanel6 = new JPanel(flowLayout);
        JPanel jPanel7 = new JPanel(flowLayout);
        JPanel jPanel8 = new JPanel(flowLayout);
        JPanel jPanel9 = new JPanel(flowLayout);
        JEditorPane jEditorPane = new JEditorPane("text/html", "<font size=\"+1\" face=\"Courier\" color=\"#000000\">&lt;&nbsp;&nbsp;Hexadecimal representation</font>");
        jEditorPane.setEditable(false);
        jEditorPane.setFocusable(false);
        jEditorPane.setForeground(Color.black);
        jEditorPane.setBackground(jPanel6.getBackground());
        JEditorPane jEditorPane2 = new JEditorPane("text/html", "<font size=\"+1\" face=\"Courier\" color=\"#000000\">&lt;&nbsp;&nbsp;Each hex digit represents 4 bits</font>");
        jEditorPane2.setEditable(false);
        jEditorPane2.setFocusable(false);
        jEditorPane2.setBackground(jPanel7.getBackground());
        JEditorPane jEditorPane3 = new JEditorPane("text/html", "<font size=\"+1\" face=\"Courier\" color=\"#000000\">&lt;&nbsp;&nbsp;Binary representation</font>");
        jEditorPane3.setEditable(false);
        jEditorPane3.setFocusable(false);
        jEditorPane3.setBackground(jPanel8.getBackground());
        JEditorPane jEditorPane4 = new JEditorPane("text/html", "<font size=\"+1\" face=\"Courier\" color=\"#000000\">&lt;&nbsp;&nbsp;Binary-to-decimal conversion</font>");
        jEditorPane4.setEditable(false);
        jEditorPane4.setFocusable(false);
        jEditorPane4.setBackground(jPanel9.getBackground());
        jPanel6.add(jEditorPane);
        jPanel7.add(jEditorPane2);
        jPanel8.add(jEditorPane3);
        jPanel9.add(jEditorPane4);
        jPanel2.add(jPanel6);
        jPanel2.add(jPanel7);
        jPanel2.add(jPanel8);
        jPanel2.add(jPanel9);
        jPanel2.add(box3);
        JPanel jPanel10 = new JPanel(new FlowLayout(0));
        this.instructions = new InstructionsPane(jPanel10);
        jPanel10.add(this.instructions);
        jPanel10.setBorder(new TitledBorder("Instructions"));
        box.add(jPanel10);
        this.fpRegisters = FloatingPointRegisterFile.getRegisters();
        String[] stringArray = new String[this.fpRegisters.length + 1];
        stringArray[0] = "None";
        for (int i = 0; i < this.fpRegisters.length; ++i) {
            stringArray[i + 1] = this.fpRegisters[i].getName();
        }
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedIndex(0);
        jComboBox.setToolTipText("Attach to selected FP register");
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                int n = jComboBox.getSelectedIndex();
                if (FloatRepresentation.this.isObserving()) {
                    FloatRepresentation.this.deleteAsObserver();
                }
                if (n == 0) {
                    FloatRepresentation.this.attachedRegister = null;
                    FloatRepresentation.this.updateDisplays(new FlavorsOfFloat());
                    FloatRepresentation.this.instructions.setText("The program is not attached to any floating point registers.");
                } else {
                    FloatRepresentation.this.attachedRegister = FloatRepresentation.this.fpRegisters[n - 1];
                    FloatRepresentation.this.updateDisplays(new FlavorsOfFloat().buildOneFromInt((int)FloatRepresentation.this.attachedRegister.getValue()));
                    if (FloatRepresentation.this.isObserving()) {
                        FloatRepresentation.this.addAsObserver();
                    }
                    FloatRepresentation.this.instructions.setText("The program and register " + FloatRepresentation.this.attachedRegister.getName() + " will respond to each other when the program is connected or running.");
                }
            }
        });
        JPanel jPanel11 = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel12 = new JPanel();
        jPanel12.add(new JLabel("Floating point Register of interest: "));
        jPanel12.add(jComboBox);
        jPanel11.add((Component)jPanel12, "West");
        jPanel11.add((Component)new JLabel(" "), "North");
        box.add(jPanel11);
        return box;
    }

    private synchronized void updateAnyAttachedRegister(int n) {
        if (this.attachedRegister != null) {
            Globals.memoryAndRegistersLock.lock();
            try {
                this.attachedRegister.setValue((long)n | 0xFFFFFFFF00000000L);
            }
            finally {
                Globals.memoryAndRegistersLock.unlock();
            }
            if (Globals.getGui() != null) {
                Globals.getGui().getRegistersPane().getFloatingPointWindow().updateRegisters();
            }
        }
    }

    private void updateDisplays(FlavorsOfFloat flavorsOfFloat) {
        int n = flavorsOfFloat.hexString.charAt(0) == '0' && (flavorsOfFloat.hexString.charAt(1) == 'x' || flavorsOfFloat.hexString.charAt(1) == 'X') ? 2 : 0;
        this.hexDisplay.setText(flavorsOfFloat.hexString.substring(n).toUpperCase());
        this.binarySignDisplay.setText(flavorsOfFloat.binaryString.substring(0, 1));
        this.binaryExponentDisplay.setText(flavorsOfFloat.binaryString.substring(1, 9));
        this.binaryFractionDisplay.setText(flavorsOfFloat.binaryString.substring(9, 32));
        this.decimalDisplay.setText(flavorsOfFloat.decimalString);
        this.binaryToDecimalFormulaGraphic.drawSubtractLabel(Binary.binaryStringToInt(flavorsOfFloat.binaryString.substring(1, 9)));
        this.expansionDisplay.setText(flavorsOfFloat.expansionString);
        this.updateSignificandLabel(flavorsOfFloat);
    }

    private void updateDisplaysAndRegister(FlavorsOfFloat flavorsOfFloat) {
        this.updateDisplays(flavorsOfFloat);
        if (this.isObserving()) {
            this.updateAnyAttachedRegister(flavorsOfFloat.intValue);
        }
    }

    private void updateSignificandLabel(FlavorsOfFloat flavorsOfFloat) {
        if (flavorsOfFloat.binaryString.substring(1, 9).equals(zeroes.substring(1, 9))) {
            if (this.significandLabel.getText().indexOf("deno") < 0) {
                this.significandLabel.setText(denormalizedLabel);
            }
        } else if (this.significandLabel.getText().indexOf("unde") < 0) {
            this.significandLabel.setText(normalizedLabel);
        }
    }

    class BinaryFractionDisplayTextField
    extends JTextField {
        public BinaryFractionDisplayTextField(String string, int n) {
            super(string, n);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }
    }

    class InstructionsPane
    extends JLabel {
        InstructionsPane(Component component) {
            super(FloatRepresentation.this.defaultInstructions);
            this.setFont(instructionsFont);
            this.setBackground(component.getBackground());
        }

        @Override
        public void setText(String string) {
            super.setText(string);
        }
    }

    class BinaryToDecimalFormulaGraphic
    extends JPanel {
        final String subtractLabelTrailer = " - 127";
        final int arrowHeadOffset = 5;
        final int lowerY = 0;
        final int upperY = 50;
        int centerX;
        int exponentCenterX;
        int subtractLabelWidth;
        int subtractLabelHeight;
        int centerY = 25;
        int upperYArrowHead = 45;
        int currentExponent = Binary.binaryStringToInt("00000000");

        BinaryToDecimalFormulaGraphic() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.centerX = FloatRepresentation.this.binarySignDecoratedDisplay.getX() + FloatRepresentation.this.binarySignDecoratedDisplay.getWidth() / 2;
            graphics.drawLine(this.centerX, 0, this.centerX, 50);
            graphics.drawLine(this.centerX - 5, this.upperYArrowHead, this.centerX, 50);
            graphics.drawLine(this.centerX + 5, this.upperYArrowHead, this.centerX, 50);
            this.centerX = FloatRepresentation.this.binaryExponentDecoratedDisplay.getX() + FloatRepresentation.this.binaryExponentDecoratedDisplay.getWidth() / 2;
            graphics.drawLine(this.centerX, 0, this.centerX, 50);
            graphics.drawLine(this.centerX - 5, this.upperYArrowHead, this.centerX, 50);
            graphics.drawLine(this.centerX + 5, this.upperYArrowHead, this.centerX, 50);
            this.exponentCenterX = this.centerX;
            this.subtractLabelHeight = graphics.getFontMetrics().getHeight();
            this.drawSubtractLabel(graphics, this.buildSubtractLabel(this.currentExponent));
            this.centerX = FloatRepresentation.this.binaryFractionDecoratedDisplay.getX() + FloatRepresentation.this.binaryFractionDecoratedDisplay.getWidth() / 2;
            graphics.drawLine(this.centerX, 0, this.centerX, 50);
            graphics.drawLine(this.centerX - 5, this.upperYArrowHead, this.centerX, 50);
            graphics.drawLine(this.centerX + 5, this.upperYArrowHead, this.centerX, 50);
        }

        public void drawSubtractLabel(int n) {
            if (n != this.currentExponent) {
                this.currentExponent = n;
                this.drawSubtractLabel(this.getGraphics(), this.buildSubtractLabel(n));
            }
        }

        private void drawSubtractLabel(Graphics graphics, String string) {
            Color color = graphics.getColor();
            graphics.setColor(FloatRepresentation.this.binaryToDecimalFormulaGraphic.getBackground());
            graphics.fillRect(this.exponentCenterX - this.subtractLabelWidth / 2, this.centerY - this.subtractLabelHeight / 2, this.subtractLabelWidth + 2, this.subtractLabelHeight);
            graphics.setColor(color);
            this.subtractLabelWidth = graphics.getFontMetrics().stringWidth(string);
            graphics.drawString(string, this.exponentCenterX - this.subtractLabelWidth / 2, this.centerY + this.subtractLabelHeight / 2 - 3);
        }

        private String buildSubtractLabel(int n) {
            return Integer.toString(n) + " - 127";
        }
    }

    class HexToBinaryGraphicPanel
    extends JPanel {
        HexToBinaryGraphicPanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Polygon polygon;
            super.paintComponent(graphics);
            graphics.setColor(Color.red);
            int n = 0;
            int n2 = 60;
            int n3 = FloatRepresentation.this.hexDisplay.getWidth() / FloatRepresentation.this.hexDisplay.getColumns();
            int n4 = FloatRepresentation.this.binaryFractionDisplay.getWidth() / FloatRepresentation.this.binaryFractionDisplay.getColumns();
            for (int i = 1; i < 6; ++i) {
                polygon = new Polygon();
                polygon.addPoint(FloatRepresentation.this.hexDisplay.getX() + n3 * (FloatRepresentation.this.hexDisplay.getColumns() - i) + n3 / 2, n);
                polygon.addPoint(FloatRepresentation.this.binaryFractionDecoratedDisplay.getX() + n4 * (FloatRepresentation.this.binaryFractionDisplay.getColumns() - (i * 5 - i)), n2);
                polygon.addPoint(FloatRepresentation.this.binaryFractionDecoratedDisplay.getX() + n4 * (FloatRepresentation.this.binaryFractionDisplay.getColumns() - (i * 5 - i - 4)), n2);
                graphics.fillPolygon(polygon);
            }
            polygon = new Polygon();
            polygon.addPoint(FloatRepresentation.this.hexDisplay.getX() + n3 * (FloatRepresentation.this.hexDisplay.getColumns() - 6) + n3 / 2, n);
            polygon.addPoint(FloatRepresentation.this.binaryFractionDecoratedDisplay.getX() + n4 * (FloatRepresentation.this.binaryFractionDisplay.getColumns() - 20), n2);
            polygon.addPoint(FloatRepresentation.this.binaryExponentDecoratedDisplay.getX() + n4 * (FloatRepresentation.this.binaryExponentDisplay.getColumns() - 1), n2);
            graphics.fillPolygon(polygon);
            polygon = new Polygon();
            polygon.addPoint(FloatRepresentation.this.hexDisplay.getX() + n3 * (FloatRepresentation.this.hexDisplay.getColumns() - 7) + n3 / 2, n);
            polygon.addPoint(FloatRepresentation.this.binaryExponentDecoratedDisplay.getX() + n4 * (FloatRepresentation.this.binaryExponentDisplay.getColumns() - 1), n2);
            polygon.addPoint(FloatRepresentation.this.binaryExponentDecoratedDisplay.getX() + n4 * (FloatRepresentation.this.binaryExponentDisplay.getColumns() - 5), n2);
            graphics.fillPolygon(polygon);
            polygon = new Polygon();
            polygon.addPoint(FloatRepresentation.this.hexDisplay.getX() + n3 * (FloatRepresentation.this.hexDisplay.getColumns() - 8) + n3 / 2, n);
            polygon.addPoint(FloatRepresentation.this.binaryExponentDecoratedDisplay.getX() + n4 * (FloatRepresentation.this.binaryExponentDisplay.getColumns() - 5), n2);
            polygon.addPoint(FloatRepresentation.this.binarySignDecoratedDisplay.getX(), n2);
            graphics.fillPolygon(polygon);
        }
    }

    private class DecimalDisplayKeystokeListenter
    extends KeyAdapter {
        private DecimalDisplayKeystokeListenter() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getComponent();
            if (keyEvent.getKeyChar() == '\b') {
                return;
            }
            if (!this.isDecimalFloatDigit(keyEvent.getKeyChar())) {
                if (keyEvent.getKeyChar() != '\n') {
                    FloatRepresentation.this.instructions.setText("Only digits, period, signs and E (or e) are accepted in decimal field.");
                    Toolkit.getDefaultToolkit().beep();
                }
                keyEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                FlavorsOfFloat flavorsOfFloat = new FlavorsOfFloat().buildOneFromDecimalString(((JTextField)keyEvent.getSource()).getText());
                if (flavorsOfFloat == null) {
                    Toolkit.getDefaultToolkit().beep();
                    FloatRepresentation.this.instructions.setText("'" + ((JTextField)keyEvent.getSource()).getText() + "' is not a valid floating point number.");
                } else {
                    FloatRepresentation.this.updateDisplaysAndRegister(flavorsOfFloat);
                    FloatRepresentation.this.instructions.setText(FloatRepresentation.this.defaultInstructions);
                }
                keyEvent.consume();
            }
        }

        private boolean isDecimalFloatDigit(char c) {
            boolean bl = false;
            switch (c) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'E': 
                case 'e': {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private class BinaryDisplayKeystrokeListener
    extends KeyAdapter {
        private int bitLength;

        public BinaryDisplayKeystrokeListener(int n) {
            this.bitLength = n;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getComponent();
            if (keyEvent.getKeyChar() == '\b') {
                return;
            }
            if (!this.isBinaryDigit(keyEvent.getKeyChar()) || keyEvent.getKeyChar() == '\n' || jTextField.getText().length() == this.bitLength && jTextField.getSelectedText() == null) {
                if (keyEvent.getKeyChar() != '\n') {
                    Toolkit.getDefaultToolkit().beep();
                    if (jTextField.getText().length() == this.bitLength && jTextField.getSelectedText() == null) {
                        FloatRepresentation.this.instructions.setText("Maximum length of this field is " + this.bitLength + ".");
                    } else {
                        FloatRepresentation.this.instructions.setText("Only 0 and 1 are accepted in binary field.");
                    }
                }
                keyEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                FloatRepresentation.this.updateDisplaysAndRegister(new FlavorsOfFloat().buildOneFromBinaryString());
                FloatRepresentation.this.instructions.setText(FloatRepresentation.this.defaultInstructions);
                keyEvent.consume();
            }
        }

        private boolean isBinaryDigit(char c) {
            boolean bl = false;
            switch (c) {
                case '0': 
                case '1': {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private class HexDisplayKeystrokeListener
    extends KeyAdapter {
        private int digitLength;

        public HexDisplayKeystrokeListener(int n) {
            this.digitLength = n;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getComponent();
            if (keyEvent.getKeyChar() == '\b' || keyEvent.getKeyChar() == '\t') {
                return;
            }
            if (!this.isHexDigit(keyEvent.getKeyChar()) || jTextField.getText().length() == this.digitLength && jTextField.getSelectedText() == null) {
                if (keyEvent.getKeyChar() != '\n' && keyEvent.getKeyChar() != '\t') {
                    Toolkit.getDefaultToolkit().beep();
                    if (jTextField.getText().length() == this.digitLength && jTextField.getSelectedText() == null) {
                        FloatRepresentation.this.instructions.setText("Maximum length of this field is " + this.digitLength + ".");
                    } else {
                        FloatRepresentation.this.instructions.setText("Only digits and A-F (or a-f) are accepted in hexadecimal field.");
                    }
                }
                keyEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\t') {
                FloatRepresentation.this.updateDisplaysAndRegister(new FlavorsOfFloat().buildOneFromHexString(((JTextField)keyEvent.getSource()).getText()));
                FloatRepresentation.this.instructions.setText(FloatRepresentation.this.defaultInstructions);
                keyEvent.consume();
            }
        }

        private boolean isHexDigit(char c) {
            boolean bl = false;
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private class FlavorsOfFloat {
        String hexString = "00000000";
        String binaryString = "00000000000000000000000000000000";
        String decimalString = "0.0";
        String expansionString = this.buildExpansionFromBinaryString(this.binaryString);
        int intValue = Float.floatToIntBits(Float.parseFloat(this.decimalString));

        private FlavorsOfFloat() {
        }

        public FlavorsOfFloat buildOneFromHexString(String string) {
            this.hexString = "0x" + this.addLeadingZeroes(string.indexOf("0X") == 0 || string.indexOf("0x") == 0 ? string.substring(2) : string, 8);
            this.binaryString = Binary.hexStringToBinaryString(this.hexString);
            this.decimalString = Float.toString(Float.intBitsToFloat(Binary.binaryStringToInt(this.binaryString)));
            this.expansionString = this.buildExpansionFromBinaryString(this.binaryString);
            this.intValue = Binary.binaryStringToInt(this.binaryString);
            return this;
        }

        private FlavorsOfFloat buildOneFromBinaryString() {
            this.binaryString = this.getFullBinaryStringFromDisplays();
            this.hexString = Binary.binaryStringToHexString(this.binaryString);
            this.decimalString = Float.toString(Float.intBitsToFloat(Binary.binaryStringToInt(this.binaryString)));
            this.expansionString = this.buildExpansionFromBinaryString(this.binaryString);
            this.intValue = Binary.binaryStringToInt(this.binaryString);
            return this;
        }

        private FlavorsOfFloat buildOneFromDecimalString(String string) {
            float f;
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            this.decimalString = Float.toString(f);
            this.intValue = Float.floatToIntBits(f);
            this.binaryString = Binary.intToBinaryString(this.intValue);
            this.hexString = Binary.binaryStringToHexString(this.binaryString);
            this.expansionString = this.buildExpansionFromBinaryString(this.binaryString);
            return this;
        }

        private FlavorsOfFloat buildOneFromInt(int n) {
            this.intValue = n;
            this.binaryString = Binary.intToBinaryString(n);
            this.hexString = Binary.binaryStringToHexString(this.binaryString);
            this.decimalString = Float.toString(Float.intBitsToFloat(Binary.binaryStringToInt(this.binaryString)));
            this.expansionString = this.buildExpansionFromBinaryString(this.binaryString);
            return this;
        }

        public String buildExpansionFromBinaryString(String string) {
            int n = Binary.binaryStringToInt(string.substring(1, 9));
            String string2 = Integer.toString(n - 127);
            return "<html><head></head><body><font size=\"+1\" face=\"Courier\" color=\"#000000\">-1<sup>" + string.substring(0, 1) + "</sup> &nbsp;*&nbsp; 2<sup>" + string2 + FloatRepresentation.HTMLspaces.substring(0, (5 - string2.length()) * 6) + "</sup> &nbsp;* &nbsp;" + (n == 0 ? "&nbsp;." : "<u>1</u>.") + string.substring(9, 32) + " =</font></body></html>";
        }

        private String getFullBinaryStringFromDisplays() {
            return this.addLeadingZeroes(FloatRepresentation.this.binarySignDisplay.getText(), 1) + this.addLeadingZeroes(FloatRepresentation.this.binaryExponentDisplay.getText(), 8) + this.addLeadingZeroes(FloatRepresentation.this.binaryFractionDisplay.getText(), 23);
        }

        private String addLeadingZeroes(String string, int n) {
            return string.length() < n ? FloatRepresentation.zeroes.substring(0, Math.min(FloatRepresentation.zeroes.length(), n - string.length())) + string : string;
        }
    }
}

