/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;
import rars.util.Binary;

public class CacheSimulator
extends AbstractToolAndApplication {
    private static boolean debug = false;
    private static final String version = "Version 1.2";
    private static final String heading = "Simulate and illustrate data cache performance";
    private JComboBox<String> cacheBlockSizeSelector;
    private JComboBox<String> cacheBlockCountSelector;
    private JComboBox<String> cachePlacementSelector;
    private JComboBox<String> cacheReplacementSelector;
    private JComboBox<String> cacheSetSizeSelector;
    private JTextField memoryAccessCountDisplay;
    private JTextField cacheHitCountDisplay;
    private JTextField cacheMissCountDisplay;
    private JTextField cacheSizeDisplay;
    private JProgressBar cacheHitRateDisplay;
    private Animation animations;
    private JPanel logPanel;
    private JScrollPane logScroll;
    private JTextArea logText;
    private JCheckBox logShow;
    private EmptyBorder emptyBorder = new EmptyBorder(4, 4, 4, 4);
    private Font countFonts = new Font("Times", 1, 12);
    private Color backgroundColor = Color.WHITE;
    private int[] cacheBlockSizeChoicesInt;
    private int[] cacheBlockCountChoicesInt;
    private static final String[] cacheBlockSizeChoices = new String[]{"1", "2", "4", "8", "16", "32", "64", "128", "256", "512", "1024", "2048"};
    private static final String[] cacheBlockCountChoices = new String[]{"1", "2", "4", "8", "16", "32", "64", "128", "256", "512", "1024", "2048"};
    private static final String[] placementPolicyChoices = new String[]{"Direct Mapping", "Fully Associative", "N-way Set Associative"};
    private static final int DIRECT = 0;
    private static final int FULL = 1;
    private static final int SET = 2;
    private static final String[] replacementPolicyChoices = new String[]{"LRU", "Random"};
    private static final int LRU = 0;
    private static final int RANDOM = 1;
    private String[] cacheSetSizeChoices;
    private static final int defaultCacheBlockSizeIndex = 2;
    private static final int defaultCacheBlockCountIndex = 3;
    private static final int defaultPlacementPolicyIndex = 0;
    private static final int defaultReplacementPolicyIndex = 0;
    private static final int defaultCacheSetSizeIndex = 0;
    private AbstractCache theCache;
    private int memoryAccessCount;
    private int cacheHitCount;
    private int cacheMissCount;
    private double cacheHitRate;
    private Random randu = new Random(0L);

    public CacheSimulator(String string, String string2) {
        super(string, string2);
    }

    public CacheSimulator() {
        super("Data Cache Simulation Tool, Version 1.2", heading);
    }

    public static void main(String[] stringArray) {
        new CacheSimulator("Data Cache Simulator stand-alone, Version 1.2", heading).go();
    }

    @Override
    public String getName() {
        return "Data Cache Simulator";
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        Box box = Box.createVerticalBox();
        box.add(this.buildOrganizationArea());
        box.add(this.buildPerformanceArea());
        box.add(this.buildLogArea());
        return box;
    }

    private JComponent buildLogArea() {
        this.logPanel = new JPanel();
        TitledBorder titledBorder = new TitledBorder("Runtime Log");
        titledBorder.setTitleJustification(2);
        this.logPanel.setBorder(titledBorder);
        this.logShow = new JCheckBox("Enabled", debug);
        this.logShow.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                debug = itemEvent.getStateChange() == 1;
                CacheSimulator.this.resetLogDisplay();
                CacheSimulator.this.logText.setEnabled(debug);
                CacheSimulator.this.logText.setBackground(debug ? Color.WHITE : CacheSimulator.this.logPanel.getBackground());
            }
        });
        this.logPanel.add(this.logShow);
        this.logText = new JTextArea(5, 70);
        this.logText.setEnabled(debug);
        this.logText.setBackground(debug ? Color.WHITE : this.logPanel.getBackground());
        this.logText.setFont(new Font("Monospaced", 0, 12));
        this.logText.setToolTipText("Displays cache activity log if enabled");
        this.logScroll = new JScrollPane(this.logText, 20, 30);
        this.logPanel.add(this.logScroll);
        return this.logPanel;
    }

    private JComponent buildOrganizationArea() {
        JPanel jPanel = new JPanel(new GridLayout(3, 2));
        TitledBorder titledBorder = new TitledBorder("Cache Organization");
        titledBorder.setTitleJustification(2);
        jPanel.setBorder(titledBorder);
        this.cachePlacementSelector = new JComboBox<String>(placementPolicyChoices);
        this.cachePlacementSelector.setEditable(false);
        this.cachePlacementSelector.setBackground(this.backgroundColor);
        this.cachePlacementSelector.setSelectedIndex(0);
        this.cachePlacementSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CacheSimulator.this.updateCacheSetSizeSelector();
                CacheSimulator.this.reset();
            }
        });
        this.cacheReplacementSelector = new JComboBox<String>(replacementPolicyChoices);
        this.cacheReplacementSelector.setEditable(false);
        this.cacheReplacementSelector.setBackground(this.backgroundColor);
        this.cacheReplacementSelector.setSelectedIndex(0);
        this.cacheBlockSizeSelector = new JComboBox<String>(cacheBlockSizeChoices);
        this.cacheBlockSizeSelector.setEditable(false);
        this.cacheBlockSizeSelector.setBackground(this.backgroundColor);
        this.cacheBlockSizeSelector.setSelectedIndex(2);
        this.cacheBlockSizeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CacheSimulator.this.updateCacheSizeDisplay();
                CacheSimulator.this.reset();
            }
        });
        this.cacheBlockCountSelector = new JComboBox<String>(cacheBlockCountChoices);
        this.cacheBlockCountSelector.setEditable(false);
        this.cacheBlockCountSelector.setBackground(this.backgroundColor);
        this.cacheBlockCountSelector.setSelectedIndex(3);
        this.cacheBlockCountSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CacheSimulator.this.updateCacheSetSizeSelector();
                CacheSimulator.this.theCache = CacheSimulator.this.createNewCache();
                CacheSimulator.this.resetCounts();
                CacheSimulator.this.updateDisplay();
                CacheSimulator.this.updateCacheSizeDisplay();
                CacheSimulator.this.animations.fillAnimationBoxWithCacheBlocks();
            }
        });
        this.cacheSetSizeSelector = new JComboBox<String>(this.cacheSetSizeChoices);
        this.cacheSetSizeSelector.setEditable(false);
        this.cacheSetSizeSelector.setBackground(this.backgroundColor);
        this.cacheSetSizeSelector.setSelectedIndex(0);
        this.cacheSetSizeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CacheSimulator.this.reset();
            }
        });
        JPanel jPanel2 = this.getPanelWithBorderLayout();
        jPanel2.setBorder(this.emptyBorder);
        jPanel2.add((Component)new JLabel("Placement Policy "), "West");
        jPanel2.add(this.cachePlacementSelector, "East");
        JPanel jPanel3 = this.getPanelWithBorderLayout();
        jPanel3.setBorder(this.emptyBorder);
        jPanel3.add((Component)new JLabel("Block Replacement Policy "), "West");
        jPanel3.add(this.cacheReplacementSelector, "East");
        JPanel jPanel4 = this.getPanelWithBorderLayout();
        jPanel4.setBorder(this.emptyBorder);
        jPanel4.add((Component)new JLabel("Set size (blocks) "), "West");
        jPanel4.add(this.cacheSetSizeSelector, "East");
        JPanel jPanel5 = this.getPanelWithBorderLayout();
        jPanel5.setBorder(this.emptyBorder);
        jPanel5.add((Component)new JLabel("Number of blocks "), "West");
        jPanel5.add(this.cacheBlockCountSelector, "East");
        JPanel jPanel6 = this.getPanelWithBorderLayout();
        jPanel6.setBorder(this.emptyBorder);
        jPanel6.add((Component)new JLabel("Cache block size (words) "), "West");
        jPanel6.add(this.cacheBlockSizeSelector, "East");
        JPanel jPanel7 = this.getPanelWithBorderLayout();
        jPanel7.setBorder(this.emptyBorder);
        jPanel7.add((Component)new JLabel("Cache size (bytes) "), "West");
        this.cacheSizeDisplay = new JTextField(8);
        this.cacheSizeDisplay.setHorizontalAlignment(4);
        this.cacheSizeDisplay.setEditable(false);
        this.cacheSizeDisplay.setBackground(this.backgroundColor);
        this.cacheSizeDisplay.setFont(this.countFonts);
        jPanel7.add((Component)this.cacheSizeDisplay, "East");
        this.updateCacheSizeDisplay();
        jPanel.add(jPanel2);
        jPanel.add(jPanel5);
        jPanel.add(jPanel3);
        jPanel.add(jPanel6);
        jPanel.add(jPanel4);
        jPanel.add(jPanel7);
        return jPanel;
    }

    private JComponent buildPerformanceArea() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        TitledBorder titledBorder = new TitledBorder("Cache Performance");
        titledBorder.setTitleJustification(2);
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = this.getPanelWithBorderLayout();
        jPanel2.setBorder(this.emptyBorder);
        jPanel2.add((Component)new JLabel("Memory Access Count "), "West");
        this.memoryAccessCountDisplay = new JTextField(10);
        this.memoryAccessCountDisplay.setHorizontalAlignment(4);
        this.memoryAccessCountDisplay.setEditable(false);
        this.memoryAccessCountDisplay.setBackground(this.backgroundColor);
        this.memoryAccessCountDisplay.setFont(this.countFonts);
        jPanel2.add((Component)this.memoryAccessCountDisplay, "East");
        JPanel jPanel3 = this.getPanelWithBorderLayout();
        jPanel3.setBorder(this.emptyBorder);
        jPanel3.add((Component)new JLabel("Cache Hit Count "), "West");
        this.cacheHitCountDisplay = new JTextField(10);
        this.cacheHitCountDisplay.setHorizontalAlignment(4);
        this.cacheHitCountDisplay.setEditable(false);
        this.cacheHitCountDisplay.setBackground(this.backgroundColor);
        this.cacheHitCountDisplay.setFont(this.countFonts);
        jPanel3.add((Component)this.cacheHitCountDisplay, "East");
        JPanel jPanel4 = this.getPanelWithBorderLayout();
        jPanel4.setBorder(this.emptyBorder);
        jPanel4.add((Component)new JLabel("Cache Miss Count "), "West");
        this.cacheMissCountDisplay = new JTextField(10);
        this.cacheMissCountDisplay.setHorizontalAlignment(4);
        this.cacheMissCountDisplay.setEditable(false);
        this.cacheMissCountDisplay.setBackground(this.backgroundColor);
        this.cacheMissCountDisplay.setFont(this.countFonts);
        jPanel4.add((Component)this.cacheMissCountDisplay, "East");
        JPanel jPanel5 = this.getPanelWithBorderLayout();
        jPanel5.setBorder(this.emptyBorder);
        jPanel5.add((Component)new JLabel("Cache Hit Rate "), "West");
        this.cacheHitRateDisplay = new JProgressBar(0, 0, 100);
        this.cacheHitRateDisplay.setStringPainted(true);
        this.cacheHitRateDisplay.setForeground(Color.BLUE);
        this.cacheHitRateDisplay.setBackground(this.backgroundColor);
        this.cacheHitRateDisplay.setFont(this.countFonts);
        jPanel5.add((Component)this.cacheHitRateDisplay, "East");
        this.resetCounts();
        this.updateDisplay();
        JPanel jPanel6 = new JPanel(new GridLayout(4, 1));
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        jPanel.add(jPanel6);
        this.animations = new Animation();
        this.animations.fillAnimationBoxWithCacheBlocks();
        JPanel jPanel7 = new JPanel(new GridLayout(1, 2));
        Box box = Box.createVerticalBox();
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        jPanel8.add(new JLabel("Cache Block Table"));
        jPanel9.add(new JLabel("(block 0 at top)"));
        box.add(jPanel8);
        box.add(jPanel9);
        Dimension dimension = new Dimension(8, 8);
        JPanel jPanel10 = new JPanel(new FlowLayout(0));
        JPanel jPanel11 = new JPanel();
        jPanel11.setSize(dimension);
        jPanel11.setBackground(this.animations.defaultColor);
        jPanel11.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        jPanel10.add(jPanel11);
        jPanel10.add(new JLabel(" = empty"));
        JPanel jPanel12 = new JPanel();
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        jPanel12.setSize(dimension);
        jPanel12.setBackground(this.animations.missColor);
        jPanel12.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        jPanel13.add(jPanel12);
        jPanel13.add(new JLabel(" = miss"));
        JPanel jPanel14 = new JPanel(new FlowLayout(0));
        JPanel jPanel15 = new JPanel();
        jPanel15.setSize(dimension);
        jPanel15.setBackground(this.animations.hitColor);
        jPanel15.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        jPanel14.add(jPanel15);
        jPanel14.add(new JLabel(" = hit"));
        box.add(jPanel10);
        box.add(jPanel14);
        box.add(jPanel13);
        box.add(Box.createVerticalGlue());
        jPanel7.add(box);
        jPanel7.add(this.animations.getAnimationBox());
        jPanel.add(jPanel7);
        return jPanel;
    }

    @Override
    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
        MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)accessNotice;
        ++this.memoryAccessCount;
        CacheAccessResult cacheAccessResult = this.theCache.isItAHitThenReadOnMiss(memoryAccessNotice.getAddress());
        if (cacheAccessResult.isHit()) {
            ++this.cacheHitCount;
            this.animations.showHit(cacheAccessResult.getBlock());
        } else {
            ++this.cacheMissCount;
            this.animations.showMiss(cacheAccessResult.getBlock());
        }
        this.cacheHitRate = (double)this.cacheHitCount / (double)this.memoryAccessCount;
    }

    @Override
    protected void initializePreGUI() {
        int n;
        this.cacheBlockSizeChoicesInt = new int[cacheBlockSizeChoices.length];
        for (n = 0; n < cacheBlockSizeChoices.length; ++n) {
            try {
                this.cacheBlockSizeChoicesInt[n] = Integer.parseInt(cacheBlockSizeChoices[n]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.cacheBlockSizeChoicesInt[n] = 1;
            }
        }
        this.cacheBlockCountChoicesInt = new int[cacheBlockCountChoices.length];
        for (n = 0; n < cacheBlockCountChoices.length; ++n) {
            try {
                this.cacheBlockCountChoicesInt[n] = Integer.parseInt(cacheBlockCountChoices[n]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.cacheBlockCountChoicesInt[n] = 1;
            }
        }
        this.cacheSetSizeChoices = this.determineSetSizeChoices(3, 0);
    }

    @Override
    protected void initializePostGUI() {
        this.theCache = this.createNewCache();
    }

    @Override
    protected void reset() {
        this.theCache = this.createNewCache();
        this.resetCounts();
        this.updateDisplay();
        this.animations.reset();
        this.resetLogDisplay();
    }

    @Override
    protected void updateDisplay() {
        this.updateMemoryAccessCountDisplay();
        this.updateCacheHitCountDisplay();
        this.updateCacheMissCountDisplay();
        this.updateCacheHitRateDisplay();
    }

    private String[] determineSetSizeChoices(int n, int n2) {
        String[] stringArray;
        int n3 = 0;
        switch (n2) {
            case 0: {
                stringArray = new String[]{cacheBlockCountChoices[n3]};
                break;
            }
            case 2: {
                stringArray = new String[n - n3 + 1];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = cacheBlockCountChoices[n3 + i];
                }
                break;
            }
            default: {
                stringArray = new String[]{cacheBlockCountChoices[n]};
            }
        }
        return stringArray;
    }

    private void updateCacheSetSizeSelector() {
        this.cacheSetSizeSelector.setModel(new DefaultComboBoxModel<String>(this.determineSetSizeChoices(this.cacheBlockCountSelector.getSelectedIndex(), this.cachePlacementSelector.getSelectedIndex())));
    }

    private AbstractCache createNewCache() {
        int n = 1;
        try {
            n = Integer.parseInt((String)this.cacheSetSizeSelector.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        AnyCache anyCache = new AnyCache(this.cacheBlockCountChoicesInt[this.cacheBlockCountSelector.getSelectedIndex()], this.cacheBlockSizeChoicesInt[this.cacheBlockSizeSelector.getSelectedIndex()], n);
        return anyCache;
    }

    private void resetCounts() {
        this.memoryAccessCount = 0;
        this.cacheHitCount = 0;
        this.cacheMissCount = 0;
        this.cacheHitRate = 0.0;
    }

    private void updateMemoryAccessCountDisplay() {
        this.memoryAccessCountDisplay.setText(Integer.toString(this.memoryAccessCount));
    }

    private void updateCacheHitCountDisplay() {
        this.cacheHitCountDisplay.setText(Integer.toString(this.cacheHitCount));
    }

    private void updateCacheMissCountDisplay() {
        this.cacheMissCountDisplay.setText(Integer.toString(this.cacheMissCount));
    }

    private void updateCacheHitRateDisplay() {
        this.cacheHitRateDisplay.setValue((int)Math.round(this.cacheHitRate * 100.0));
    }

    private void updateCacheSizeDisplay() {
        int n = this.cacheBlockSizeChoicesInt[this.cacheBlockSizeSelector.getSelectedIndex()] * this.cacheBlockCountChoicesInt[this.cacheBlockCountSelector.getSelectedIndex()] * 4;
        this.cacheSizeDisplay.setText(Integer.toString(n));
    }

    private JPanel getPanelWithBorderLayout() {
        return new JPanel(new BorderLayout(2, 2));
    }

    private void resetLogDisplay() {
        this.logText.setText("");
    }

    private void writeLog(String string) {
        this.logText.append(string);
        this.logText.setCaretPosition(this.logText.getDocument().getLength());
    }

    private class Animation {
        private Box animation;
        private JTextField[] blocks;
        public final Color hitColor = Color.GREEN;
        public final Color missColor = Color.RED;
        public final Color defaultColor = Color.WHITE;

        public Animation() {
            this.animation = Box.createVerticalBox();
        }

        private Box getAnimationBox() {
            return this.animation;
        }

        public int getNumberOfBlocks() {
            return this.blocks == null ? 0 : this.blocks.length;
        }

        public void showHit(int n) {
            this.blocks[n].setBackground(this.hitColor);
        }

        public void showMiss(int n) {
            this.blocks[n].setBackground(this.missColor);
        }

        public void reset() {
            for (JTextField jTextField : this.blocks) {
                jTextField.setBackground(this.defaultColor);
            }
        }

        private void fillAnimationBoxWithCacheBlocks() {
            this.animation.setVisible(false);
            this.animation.removeAll();
            int n = CacheSimulator.this.cacheBlockCountChoicesInt[CacheSimulator.this.cacheBlockCountSelector.getSelectedIndex()];
            int n2 = 128;
            int n3 = n > n2 ? 1 : n2 / n;
            int n4 = 40;
            Dimension dimension = new Dimension(n4, n3);
            this.blocks = new JTextField[n];
            for (int i = 0; i < n; ++i) {
                this.blocks[i] = new JTextField();
                this.blocks[i].setEditable(false);
                this.blocks[i].setBackground(this.defaultColor);
                this.blocks[i].setSize(dimension);
                this.blocks[i].setPreferredSize(dimension);
                this.animation.add(this.blocks[i]);
            }
            this.animation.repaint();
            this.animation.setVisible(true);
        }
    }

    private class AnyCache
    extends AbstractCache {
        private final int SET_FULL = 0;
        private final int HIT = 1;
        private final int MISS = 2;

        public AnyCache(int n, int n2, int n3) {
            super(n, n2, n3);
            this.SET_FULL = 0;
            this.HIT = 1;
            this.MISS = 2;
        }

        @Override
        public CacheAccessResult isItAHitThenReadOnMiss(int n) {
            CacheBlock cacheBlock;
            int n2;
            int n3 = 0;
            int n4 = this.getFirstBlockToSearch(n);
            int n5 = this.getLastBlockToSearch(n);
            if (debug) {
                CacheSimulator.this.writeLog("(" + CacheSimulator.this.memoryAccessCount + ") address: " + Binary.intToHexString(n) + " (tag " + Binary.intToHexString(this.getTag(n)) + ")  block range: " + n4 + "-" + n5 + "\n");
            }
            for (n2 = n4; n2 <= n5; ++n2) {
                cacheBlock = this.blocks[n2];
                if (debug) {
                    CacheSimulator.this.writeLog("   trying block " + n2 + (cacheBlock.valid ? " tag " + Binary.intToHexString(cacheBlock.tag) : " empty"));
                }
                if (cacheBlock.valid && cacheBlock.tag == this.getTag(n)) {
                    if (debug) {
                        CacheSimulator.this.writeLog(" -- HIT\n");
                    }
                    n3 = 1;
                    cacheBlock.mostRecentAccessTime = CacheSimulator.this.memoryAccessCount;
                    break;
                }
                if (!cacheBlock.valid) {
                    if (debug) {
                        CacheSimulator.this.writeLog(" -- MISS\n");
                    }
                    n3 = 2;
                    cacheBlock.valid = true;
                    cacheBlock.tag = this.getTag(n);
                    cacheBlock.mostRecentAccessTime = CacheSimulator.this.memoryAccessCount;
                    break;
                }
                if (!debug) continue;
                CacheSimulator.this.writeLog(" -- OCCUPIED\n");
            }
            if (n3 == 0) {
                if (debug) {
                    CacheSimulator.this.writeLog("   MISS due to FULL SET");
                }
                int n6 = this.selectBlockToReplace(n4, n5);
                cacheBlock = this.blocks[n6];
                cacheBlock.tag = this.getTag(n);
                cacheBlock.mostRecentAccessTime = CacheSimulator.this.memoryAccessCount;
                n2 = n6;
            }
            return new CacheAccessResult(n3 == 1, n2);
        }

        private int selectBlockToReplace(int n, int n2) {
            int n3 = n;
            if (n != n2) {
                switch (CacheSimulator.this.cacheReplacementSelector.getSelectedIndex()) {
                    case 1: {
                        n3 = n + CacheSimulator.this.randu.nextInt(n2 - n + 1);
                        if (!debug) break;
                        CacheSimulator.this.writeLog(" -- Random replace block " + n3 + "\n");
                        break;
                    }
                    default: {
                        int n4 = CacheSimulator.this.memoryAccessCount;
                        for (int i = n; i <= n2; ++i) {
                            if (this.blocks[i].mostRecentAccessTime >= n4) continue;
                            n4 = this.blocks[i].mostRecentAccessTime;
                            n3 = i;
                        }
                        if (!debug) break;
                        CacheSimulator.this.writeLog(" -- LRU replace block " + n3 + "; unused since (" + n4 + ")\n");
                    }
                }
            }
            return n3;
        }
    }

    private abstract class AbstractCache {
        private final int numberOfBlocks;
        private final int blockSizeInWords;
        private final int setSizeInBlocks;
        private final int numberOfSets;
        protected CacheBlock[] blocks;

        protected AbstractCache(int n, int n2, int n3) {
            this.numberOfBlocks = n;
            this.blockSizeInWords = n2;
            this.setSizeInBlocks = n3;
            this.numberOfSets = n / n3;
            this.blocks = new CacheBlock[n];
            this.reset();
        }

        public int getNumberOfBlocks() {
            return this.numberOfBlocks;
        }

        public int getNumberOfSets() {
            return this.numberOfSets;
        }

        public int getSetSizeInBlocks() {
            return this.setSizeInBlocks;
        }

        public int getBlockSizeInWords() {
            return this.blockSizeInWords;
        }

        public int getCacheSizeInWords() {
            return this.numberOfBlocks * this.blockSizeInWords;
        }

        public int getCacheSizeInBytes() {
            return this.numberOfBlocks * this.blockSizeInWords * 4;
        }

        public int getSetNumber(int n) {
            return n / 4 / this.blockSizeInWords % this.numberOfSets;
        }

        public int getTag(int n) {
            return n / 4 / this.blockSizeInWords / this.numberOfSets;
        }

        public int getFirstBlockToSearch(int n) {
            return this.getSetNumber(n) * this.setSizeInBlocks;
        }

        public int getLastBlockToSearch(int n) {
            return this.getFirstBlockToSearch(n) + this.setSizeInBlocks - 1;
        }

        public void reset() {
            for (int i = 0; i < this.numberOfBlocks; ++i) {
                this.blocks[i] = new CacheBlock(this.blockSizeInWords);
            }
            System.gc();
        }

        public abstract CacheAccessResult isItAHitThenReadOnMiss(int var1);
    }

    private class CacheAccessResult {
        private final boolean hitOrMiss;
        private final int blockNumber;

        public CacheAccessResult(boolean bl, int n) {
            this.hitOrMiss = bl;
            this.blockNumber = n;
        }

        public boolean isHit() {
            return this.hitOrMiss;
        }

        public int getBlock() {
            return this.blockNumber;
        }
    }

    private class CacheBlock {
        private boolean valid = false;
        private int tag = 0;
        private int sizeInWords;
        private int mostRecentAccessTime;

        public CacheBlock(int n) {
            this.sizeInWords = n;
            this.mostRecentAccessTime = -1;
        }
    }
}

