/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import rars.riscv.syscalls.EndOfTrackListener;

class Tone
implements Runnable {
    public static final int TEMPO = 1000;
    public static final int DEFAULT_CHANNEL = 0;
    private byte pitch;
    private int duration;
    private byte instrument;
    private byte volume;
    private static Lock openLock = new ReentrantLock();

    public Tone(byte by, int n, byte by2, byte by3) {
        this.pitch = by;
        this.duration = n;
        this.instrument = by2;
        this.volume = by3;
    }

    @Override
    public void run() {
        this.playTone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playTone() {
        try {
            Sequencer sequencer = null;
            openLock.lock();
            try {
                sequencer = MidiSystem.getSequencer();
                sequencer.open();
            }
            finally {
                openLock.unlock();
            }
            Sequence sequence = new Sequence(0.0f, 1);
            sequencer.setTempoInMPQ(1000.0f);
            Track track = sequence.createTrack();
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(192, 0, this.instrument, 0);
            MidiEvent midiEvent = new MidiEvent(shortMessage, 0L);
            track.add(midiEvent);
            ShortMessage shortMessage2 = new ShortMessage();
            shortMessage2.setMessage(144, 0, this.pitch, this.volume);
            MidiEvent midiEvent2 = new MidiEvent(shortMessage2, 0L);
            track.add(midiEvent2);
            ShortMessage shortMessage3 = new ShortMessage();
            shortMessage3.setMessage(128, 0, this.pitch, this.volume);
            MidiEvent midiEvent3 = new MidiEvent(shortMessage3, this.duration);
            track.add(midiEvent3);
            sequencer.setSequence(sequence);
            EndOfTrackListener endOfTrackListener = new EndOfTrackListener();
            sequencer.addMetaEventListener(endOfTrackListener);
            sequencer.start();
            try {
                endOfTrackListener.awaitEndOfTrack();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                sequencer.close();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }
}

