/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import rars.ExitingException;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.util.SystemIO;

public class SyscallReadFloat
extends AbstractSyscall {
    public SyscallReadFloat() {
        super("ReadFloat", "Reads a float from input console", "N/A", "fa0 = the float");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        float f;
        try {
            f = SystemIO.readFloat(this.getNumber());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExitingException(programStatement, "invalid float input (syscall " + this.getNumber() + ")");
        }
        FloatingPointRegisterFile.updateRegister(10, Float.floatToRawIntBits(f));
    }
}

