/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import java.util.Random;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.syscalls.RandomStreams;

public class SyscallRandSeed
extends AbstractSyscall {
    public SyscallRandSeed() {
        super("RandSeed", "Set seed for the underlying Java pseudorandom number generator", "a0 = index of pseudorandom number generator<br>a1 = the seed", "N/A");
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        Integer n = RegisterFile.getValue("a0");
        Random random = RandomStreams.randomStreams.get(n);
        if (random == null) {
            RandomStreams.randomStreams.put(n, new Random(RegisterFile.getValue("a1")));
        } else {
            random.setSeed(RegisterFile.getValue("a1"));
        }
    }
}

