/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import java.nio.charset.StandardCharsets;
import rars.ExitingException;
import rars.Globals;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.RegisterFile;

public class SyscallGetCWD
extends AbstractSyscall {
    public SyscallGetCWD() {
        super("GetCWD", "Writes the path of the current working directory into a buffer", "a0 = the buffer to write into <br>a1 = the length of the buffer", "a0 = -1 if the path is longer than the buffer");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        byte[] byArray;
        String string = System.getProperty("user.dir");
        int n = RegisterFile.getValue("a0");
        int n2 = RegisterFile.getValue("a1");
        if (n2 < (byArray = string.getBytes(StandardCharsets.UTF_8)).length + 1) {
            RegisterFile.updateRegister("a0", -1L);
            return;
        }
        try {
            for (int i = 0; i < byArray.length; ++i) {
                Globals.memory.setByte(n + i, byArray[i]);
            }
            Globals.memory.setByte(n + byArray.length, 0);
        }
        catch (AddressErrorException addressErrorException) {
            throw new ExitingException(programStatement, addressErrorException);
        }
    }
}

