/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.RegisterFile;

public abstract class Store
extends BasicInstruction {
    public Store(String string, String string2, String string3) {
        super(string, string2, BasicInstructionFormat.S_FORMAT, "sssssss fffff ttttt " + string3 + " sssss 0100011");
    }

    public Store(String string, String string2, String string3, boolean bl) {
        super(string, string2, BasicInstructionFormat.S_FORMAT, "sssssss fffff ttttt " + string3 + " sssss 0100011", bl);
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        nArray[1] = nArray[1] << 20 >> 20;
        try {
            this.store(RegisterFile.getValue(nArray[2]) + nArray[1], RegisterFile.getValueLong(nArray[0]));
        }
        catch (AddressErrorException addressErrorException) {
            throw new SimulationException(programStatement, addressErrorException);
        }
    }

    protected abstract void store(int var1, long var2) throws AddressErrorException;
}

