/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import java.math.BigInteger;
import rars.riscv.instructions.Arithmetic;

public class MULHU
extends Arithmetic {
    public MULHU() {
        super("mulhu t1,t2,t3", "Multiplication: set t1 to the upper 32 bits of t2*t3 using unsigned multiplication", "0000001", "011");
    }

    @Override
    public long compute(long l, long l2) {
        BigInteger bigInteger = BigInteger.valueOf(l);
        if (l < 0L) {
            bigInteger = bigInteger.add(BigInteger.ONE.shiftLeft(64));
        }
        BigInteger bigInteger2 = BigInteger.valueOf(l2);
        if (l2 < 0L) {
            bigInteger2 = bigInteger2.add(BigInteger.ONE.shiftLeft(64));
        }
        return bigInteger.multiply(bigInteger2).shiftRight(64).longValue();
    }

    @Override
    public int computeW(int n, int n2) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        return (int)(l * l2 >> 32);
    }
}

