/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.types.Float64;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.instructions.Floating;

public abstract class FusedDouble
extends BasicInstruction {
    public FusedDouble(String string, String string2, String string3) {
        super(string + ", dyn", string2, BasicInstructionFormat.R4_FORMAT, "qqqqq 01 ttttt sssss ppp fffff 100" + string3 + "11");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[4], programStatement);
        Float64 float64 = this.compute(new Float64(FloatingPointRegisterFile.getValueLong(nArray[1])), new Float64(FloatingPointRegisterFile.getValueLong(nArray[2])), new Float64(FloatingPointRegisterFile.getValueLong(nArray[3])), environment);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegisterLong(nArray[0], float64.bits);
    }

    protected abstract Float64 compute(Float64 var1, Float64 var2, Float64 var3, Environment var4);
}

