/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class CSRRW
extends BasicInstruction {
    public CSRRW() {
        super("csrrw t0, fcsr, t1", "Atomic Read/Write CSR: read from the CSR into t0 and write t1 into the CSR", BasicInstructionFormat.I_FORMAT, "ssssssssssss ttttt 001 fffff 1110011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        try {
            long l = ControlAndStatusRegisterFile.getValueLong(nArray[1]);
            if (ControlAndStatusRegisterFile.updateRegister(nArray[1], RegisterFile.getValueLong(nArray[2]))) {
                throw new SimulationException(programStatement, "Attempt to write to read-only CSR", 2);
            }
            RegisterFile.updateRegister(nArray[0], l);
        }
        catch (NullPointerException nullPointerException) {
            throw new SimulationException(programStatement, "Attempt to access unavailable CSR", 2);
        }
    }
}

