/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

import java.util.Observer;
import rars.Globals;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterBlock;

public class FloatingPointRegisterFile {
    private static final RegisterBlock instance = new RegisterBlock('f', new Register[]{new Register("ft0", 0, 0L), new Register("ft1", 1, 0L), new Register("ft2", 2, 0L), new Register("ft3", 3, 0L), new Register("ft4", 4, 0L), new Register("ft5", 5, 0L), new Register("ft6", 6, 0L), new Register("ft7", 7, 0L), new Register("fs0", 8, 0L), new Register("fs1", 9, 0L), new Register("fa0", 10, 0L), new Register("fa1", 11, 0L), new Register("fa2", 12, 0L), new Register("fa3", 13, 0L), new Register("fa4", 14, 0L), new Register("fa5", 15, 0L), new Register("fa6", 16, 0L), new Register("fa7", 17, 0L), new Register("fs2", 18, 0L), new Register("fs3", 19, 0L), new Register("fs4", 20, 0L), new Register("fs5", 21, 0L), new Register("fs6", 22, 0L), new Register("fs7", 23, 0L), new Register("fs8", 24, 0L), new Register("fs9", 25, 0L), new Register("fs10", 26, 0L), new Register("fs11", 27, 0L), new Register("ft8", 28, 0L), new Register("ft9", 29, 0L), new Register("ft10", 30, 0L), new Register("ft11", 31, 0L)});

    public static void setRegisterToFloat(int n, float f) {
        FloatingPointRegisterFile.updateRegister(n, Float.floatToRawIntBits(f));
    }

    public static float getFloatFromRegister(String string) {
        return Float.intBitsToFloat(FloatingPointRegisterFile.getValue(string));
    }

    public static void updateRegister(int n, int n2) {
        long l = (long)n2 | 0xFFFFFFFF00000000L;
        if (Globals.getSettings().getBackSteppingEnabled()) {
            Globals.program.getBackStepper().addFloatingPointRestore(n, instance.updateRegister(n, l));
        } else {
            instance.updateRegister(n, l);
        }
    }

    public static void updateRegisterLong(int n, long l) {
        if (Globals.getSettings().getBackSteppingEnabled()) {
            Globals.program.getBackStepper().addFloatingPointRestore(n, instance.updateRegister(n, l));
        } else {
            instance.updateRegister(n, l);
        }
    }

    public static int getValue(int n) {
        long l = instance.getValue(n);
        if ((l & 0xFFFFFFFF00000000L) == -4294967296L) {
            return (int)l;
        }
        return 2143289344;
    }

    public static long getValueLong(int n) {
        return instance.getValue(n);
    }

    public static int getValue(String string) {
        long l = instance.getValue(string);
        if ((l & 0xFFFFFFFF00000000L) == -4294967296L) {
            return (int)l;
        }
        return 2143289344;
    }

    public static Register[] getRegisters() {
        return instance.getRegisters();
    }

    public static Register getRegister(String string) {
        return instance.getRegister(string);
    }

    public static void resetRegisters() {
        instance.resetRegisters();
    }

    public static void addRegistersObserver(Observer observer) {
        instance.addRegistersObserver(observer);
    }

    public static void deleteRegistersObserver(Observer observer) {
        instance.deleteRegistersObserver(observer);
    }
}

