/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.dump;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import rars.riscv.dump.AbstractDumpFormat;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;

public class IntelHexDumpFormat
extends AbstractDumpFormat {
    public IntelHexDumpFormat() {
        super("Intel hex format", "HEX", "Written as Intel Hex Memory File", "hex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpMemoryRange(File file, int n, int n2, Memory memory) throws AddressErrorException, IOException {
        String string = null;
        try (PrintStream printStream = new PrintStream(new FileOutputStream(file));){
            Integer n3;
            for (int i = n; i <= n2 && (n3 = memory.getRawWordOrNull(i)) != null; i += 4) {
                string = Integer.toHexString(n3);
                while (string.length() < 8) {
                    string = '0' + string;
                }
                String string2 = Integer.toHexString(i - n);
                while (string2.length() < 4) {
                    string2 = '0' + string2;
                }
                int n4 = 0;
                n4 += 4;
                n4 += 0xFF & i - n;
                n4 += 0xFF & i - n >> 8;
                n4 += 0xFF & n3;
                n4 += 0xFF & n3 >> 8;
                n4 += 0xFF & n3 >> 16;
                n4 += 0xFF & n3 >> 24;
                n4 %= 256;
                String string3 = Integer.toHexString(0xFF & (n4 = ~n4 + 1));
                if (string3.length() == 1) {
                    string3 = '0' + string3;
                }
                String string4 = ":04" + string2 + "00" + string + string3;
                printStream.println(string4.toUpperCase());
            }
            printStream.println(":00000001FF");
        }
    }
}

