/*
 * Decompiled with CFR 0.152.
 */
package rars.extras;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import rars.Globals;
import rars.Settings;
import rars.assembler.Directives;
import rars.riscv.AbstractSyscall;
import rars.riscv.BasicInstruction;
import rars.riscv.ExtendedInstruction;
import rars.riscv.Instruction;
import rars.riscv.InstructionSet;
import rars.riscv.SyscallLoader;

public class Documentation {
    public static void main(String[] stringArray) {
        Globals.initialize();
        System.out.println(Documentation.createDirectiveMarkdown());
        System.out.println(Documentation.createSyscallMarkdown());
        System.out.println(Documentation.createInstructionMarkdown(BasicInstruction.class));
        System.out.println(Documentation.createInstructionMarkdown(ExtendedInstruction.class));
        System.out.println(Documentation.createInstructionMarkdown64Only(BasicInstruction.class));
        System.out.println(Documentation.createInstructionMarkdown64Only(ExtendedInstruction.class));
    }

    public static String createDirectiveMarkdown() {
        ArrayList<Directives> arrayList = Directives.getDirectiveList();
        arrayList.sort(Comparator.comparing(Directives::getName));
        StringBuilder stringBuilder = new StringBuilder("| Name | Description|\n|------|------------|");
        for (Directives directives : arrayList) {
            stringBuilder.append("\n|");
            stringBuilder.append(directives.getName());
            stringBuilder.append('|');
            stringBuilder.append(directives.getDescription());
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    public static String createSyscallMarkdown() {
        ArrayList<AbstractSyscall> arrayList = SyscallLoader.getSyscallList();
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder("| Name | Call Number (a7) | Description | Inputs | Outputs |\n|------|------------------|-------------|--------|---------|");
        for (AbstractSyscall abstractSyscall : arrayList) {
            stringBuilder.append("\n|");
            stringBuilder.append(abstractSyscall.getName());
            stringBuilder.append('|');
            stringBuilder.append(abstractSyscall.getNumber());
            stringBuilder.append('|');
            stringBuilder.append(abstractSyscall.getDescription());
            stringBuilder.append('|');
            stringBuilder.append(abstractSyscall.getInputs());
            stringBuilder.append('|');
            stringBuilder.append(abstractSyscall.getOutputs());
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    public static String createInstructionMarkdown(Class<? extends Instruction> clazz) {
        Globals.getSettings().setBooleanSettingNonPersistent(Settings.Bool.RV64_ENABLED, false);
        InstructionSet.rv64 = false;
        Globals.instructionSet.populate();
        ArrayList<Instruction> arrayList = Globals.instructionSet.getInstructionList();
        arrayList.sort(Comparator.comparing(Instruction::getExampleFormat));
        StringBuilder stringBuilder = new StringBuilder("| Example Usage | Description |\n|---------------|-------------|");
        for (Instruction instruction : arrayList) {
            if (!clazz.isInstance(instruction)) continue;
            stringBuilder.append("\n|");
            stringBuilder.append(instruction.getExampleFormat());
            stringBuilder.append('|');
            stringBuilder.append(instruction.getDescription());
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    public static String createInstructionMarkdown64Only(Class<? extends Instruction> clazz) {
        Globals.getSettings().setBooleanSettingNonPersistent(Settings.Bool.RV64_ENABLED, false);
        InstructionSet.rv64 = false;
        Globals.instructionSet.populate();
        HashSet<String> hashSet = new HashSet<String>();
        for (Instruction object2 : Globals.instructionSet.getInstructionList()) {
            hashSet.add(object2.getExampleFormat());
        }
        Globals.getSettings().setBooleanSettingNonPersistent(Settings.Bool.RV64_ENABLED, true);
        InstructionSet.rv64 = true;
        Globals.instructionSet.populate();
        ArrayList<Instruction> arrayList = Globals.instructionSet.getInstructionList();
        arrayList.sort(Comparator.comparing(Instruction::getExampleFormat));
        StringBuilder stringBuilder = new StringBuilder("| Example Usage | Description |\n|---------------|-------------|");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (!clazz.isInstance(instruction) || hashSet.contains(instruction.getExampleFormat())) continue;
            stringBuilder.append("\n|");
            stringBuilder.append(instruction.getExampleFormat());
            stringBuilder.append('|');
            stringBuilder.append(instruction.getDescription());
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }
}

