/*
 * Decompiled with CFR 0.152.
 */
package rars.assembler;

import rars.Globals;
import rars.assembler.Directives;
import rars.assembler.Macro;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterFile;
import rars.util.Binary;

public enum TokenTypes {
    COMMENT,
    DIRECTIVE,
    OPERATOR,
    DELIMITER,
    REGISTER_NAME,
    REGISTER_NUMBER,
    FP_REGISTER_NAME,
    CSR_NAME,
    ROUNDING_MODE,
    IDENTIFIER,
    LEFT_PAREN,
    RIGHT_PAREN,
    INTEGER_5,
    INTEGER_6,
    INTEGER_12,
    INTEGER_12U,
    INTEGER_20,
    INTEGER_32,
    INTEGER_64,
    REAL_NUMBER,
    QUOTED_STRING,
    PLUS,
    MINUS,
    COLON,
    ERROR,
    MACRO_PARAMETER,
    HI,
    LO,
    TAG;

    public static final String TOKEN_DELIMITERS = "\t ,()";

    public String toString() {
        return this.name();
    }

    public static TokenTypes matchTokenType(String string) {
        Register[] registerArray;
        if (string.charAt(0) == '\'') {
            return ERROR;
        }
        if (string.charAt(0) == '#') {
            return COMMENT;
        }
        if (string.charAt(0) == '@') {
            return TAG;
        }
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case '(': {
                    return LEFT_PAREN;
                }
                case ')': {
                    return RIGHT_PAREN;
                }
                case ':': {
                    return COLON;
                }
                case '+': {
                    return PLUS;
                }
                case '-': {
                    return MINUS;
                }
            }
        }
        if (string.equals("%hi")) {
            return HI;
        }
        if (string.equals("%lo")) {
            return LO;
        }
        if (string.equals("rne") || string.equals("rtz") || string.equals("rdn") || string.equals("rup") || string.equals("rmm") || string.equals("dyn")) {
            return ROUNDING_MODE;
        }
        if (Macro.tokenIsMacroParameter(string, false)) {
            return MACRO_PARAMETER;
        }
        Register register = RegisterFile.getRegister(string);
        if (register != null) {
            if (string.startsWith("x")) {
                return REGISTER_NUMBER;
            }
            return REGISTER_NAME;
        }
        register = FloatingPointRegisterFile.getRegister(string);
        if (register != null) {
            return FP_REGISTER_NAME;
        }
        for (Register register2 : registerArray = ControlAndStatusRegisterFile.getRegisters()) {
            if (!register2.getName().equals(string)) continue;
            return CSR_NAME;
        }
        try {
            int n = Binary.stringToInt(string);
            if (n >= 0 && n <= 31) {
                return INTEGER_5;
            }
            if (n >= 0 && n <= 64) {
                return INTEGER_6;
            }
            if (n >= -2048 && n <= 2047) {
                return INTEGER_12;
            }
            if (n >= 0 && n <= 4095) {
                return INTEGER_12U;
            }
            if (n >= 0 && n <= 1048575) {
                return INTEGER_20;
            }
            return INTEGER_32;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Binary.stringToLong(string);
                return INTEGER_64;
            }
            catch (NumberFormatException numberFormatException2) {
                if (string.equals("Inf") || string.equals("NaN")) {
                    return REAL_NUMBER;
                }
                if ('0' <= string.charAt(0) && string.charAt(0) <= '9' || string.charAt(0) == '.' || string.charAt(0) == '-') {
                    try {
                        Double.parseDouble(string);
                        return REAL_NUMBER;
                    }
                    catch (NumberFormatException numberFormatException3) {
                        // empty catch block
                    }
                }
                if (string.charAt(0) == '.' && Directives.matchDirective(string) != null) {
                    return DIRECTIVE;
                }
                if (string.charAt(0) == '\"') {
                    return QUOTED_STRING;
                }
                if (Globals.instructionSet.matchOperator(string) != null) {
                    return OPERATOR;
                }
                if (TokenTypes.isValidIdentifier(string)) {
                    return IDENTIFIER;
                }
                return ERROR;
            }
        }
    }

    public static boolean isIntegerTokenType(TokenTypes tokenTypes) {
        return tokenTypes == INTEGER_5 || tokenTypes == INTEGER_6 || tokenTypes == INTEGER_12 || tokenTypes == INTEGER_12U || tokenTypes == INTEGER_20 || tokenTypes == INTEGER_32 || tokenTypes == INTEGER_64;
    }

    public static boolean isFloatingTokenType(TokenTypes tokenTypes) {
        return tokenTypes == REAL_NUMBER;
    }

    public static boolean isValidIdentifier(String string) {
        boolean bl = Character.isLetter(string.charAt(0)) || string.charAt(0) == '_' || string.charAt(0) == '.' || string.charAt(0) == '$';
        for (int i = 1; bl && i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '_' || string.charAt(i) == '.' || string.charAt(i) == '$') continue;
            bl = false;
        }
        return bl;
    }
}

