/*
 * Decompiled with CFR 0.152.
 */
package rars.assembler;

import java.util.ArrayList;
import rars.ErrorList;
import rars.ErrorMessage;
import rars.Globals;
import rars.assembler.Symbol;
import rars.assembler.Token;
import rars.util.Binary;

public class SymbolTable {
    private static String startLabel = "main";
    private String filename;
    private ArrayList<Symbol> table;
    public static final int NOT_FOUND = -1;

    public SymbolTable(String string) {
        this.filename = string;
        this.table = new ArrayList();
    }

    public void addSymbol(Token token, int n, boolean bl, ErrorList errorList) {
        String string = token.getValue();
        if (this.getSymbol(string) != null) {
            errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "label \"" + string + "\" already defined"));
        } else {
            this.table.add(new Symbol(string, n, bl));
            if (Globals.debug) {
                System.out.println("The symbol " + string + " with address " + n + " has been added to the " + this.filename + " symbol table.");
            }
        }
    }

    public void removeSymbol(Token token) {
        String string = token.getValue();
        for (int i = 0; i < this.table.size(); ++i) {
            if (!this.table.get(i).getName().equals(string)) continue;
            this.table.remove(i);
            if (!Globals.debug) break;
            System.out.println("The symbol " + string + " has been removed from the " + this.filename + " symbol table.");
            break;
        }
    }

    public int getAddress(String string) {
        for (Symbol symbol : this.table) {
            if (!symbol.getName().equals(string)) continue;
            return symbol.getAddress();
        }
        return -1;
    }

    public int getAddressLocalOrGlobal(String string) {
        int n = this.getAddress(string);
        return n == -1 ? Globals.symbolTable.getAddress(string) : n;
    }

    public Symbol getSymbol(String string) {
        for (Symbol symbol : this.table) {
            if (!symbol.getName().equals(string)) continue;
            return symbol;
        }
        return null;
    }

    public Symbol getSymbolGivenAddress(String string) {
        int n;
        try {
            n = Binary.stringToInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        for (Symbol symbol : this.table) {
            if (symbol.getAddress() != n) continue;
            return symbol;
        }
        return null;
    }

    public Symbol getSymbolGivenAddressLocalOrGlobal(String string) {
        Symbol symbol = this.getSymbolGivenAddress(string);
        return symbol == null ? Globals.symbolTable.getSymbolGivenAddress(string) : symbol;
    }

    public ArrayList<Symbol> getDataSymbols() {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        for (Symbol symbol : this.table) {
            if (!symbol.getType()) continue;
            arrayList.add(symbol);
        }
        return arrayList;
    }

    public ArrayList<Symbol> getTextSymbols() {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        for (Symbol symbol : this.table) {
            if (symbol.getType()) continue;
            arrayList.add(symbol);
        }
        return arrayList;
    }

    public ArrayList<Symbol> getAllSymbols() {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        arrayList.addAll(this.table);
        return arrayList;
    }

    public int getSize() {
        return this.table.size();
    }

    public void clear() {
        this.table = new ArrayList();
    }

    public void fixSymbolTableAddress(int n, int n2) {
        Symbol symbol = this.getSymbolGivenAddress(Integer.toString(n));
        while (symbol != null) {
            symbol.setAddress(n2);
            symbol = this.getSymbolGivenAddress(Integer.toString(n));
        }
    }

    public static String getStartLabel() {
        return startLabel;
    }
}

