/*
 * Decompiled with CFR 0.152.
 */
package rars.assembler;

import java.util.ArrayList;
import java.util.Collections;
import rars.ErrorList;
import rars.ErrorMessage;
import rars.RISCVprogram;
import rars.assembler.Token;
import rars.assembler.TokenList;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class Macro {
    private String name = "";
    private RISCVprogram program = null;
    private ArrayList<String> labels;
    private int fromLine = 0;
    private int toLine = 0;
    private int origFromLine = 0;
    private int origToLine = 0;
    private ArrayList<String> args = new ArrayList();

    public Macro() {
        this.labels = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public RISCVprogram getProgram() {
        return this.program;
    }

    public void setProgram(RISCVprogram rISCVprogram) {
        this.program = rISCVprogram;
    }

    public int getFromLine() {
        return this.fromLine;
    }

    public int getOriginalFromLine() {
        return this.origFromLine;
    }

    public void setFromLine(int n) {
        this.fromLine = n;
    }

    public void setOriginalFromLine(int n) {
        this.origFromLine = n;
    }

    public int getToLine() {
        return this.toLine;
    }

    public int getOriginalToLine() {
        return this.origToLine;
    }

    public void setToLine(int n) {
        this.toLine = n;
    }

    public void setOriginalToLine(int n) {
        this.origToLine = n;
    }

    public ArrayList<String> getArgs() {
        return this.args;
    }

    public void setArgs(ArrayList<String> arrayList) {
        this.args = arrayList;
    }

    public boolean equals(Object object) {
        if (object instanceof Macro) {
            Macro macro = (Macro)object;
            return macro.getName().equals(this.name) && macro.args.size() == this.args.size();
        }
        return super.equals(object);
    }

    public void addArg(String string) {
        this.args.add(string);
    }

    public String getSubstitutedLine(int n, TokenList tokenList, long l, ErrorList errorList) {
        TokenList tokenList2 = this.program.getTokenList().get(n - 1);
        String string = this.program.getSourceLine(n);
        for (int i = tokenList2.size() - 1; i >= 0; --i) {
            Token token = tokenList2.get(i);
            if (Macro.tokenIsMacroParameter(token.getValue(), true)) {
                int n2 = -1;
                for (int j = 0; j < this.args.size(); ++j) {
                    if (!this.args.get(j).equals(token.getValue())) continue;
                    n2 = j;
                    break;
                }
                String string2 = token.getValue();
                if (n2 != -1) {
                    string2 = tokenList.get(n2 + 1).toString();
                } else {
                    errorList.add(new ErrorMessage(this.program, token.getSourceLine(), token.getStartPos(), "Unknown macro parameter"));
                }
                string = this.replaceToken(string, token, string2);
                continue;
            }
            if (!this.tokenIsMacroLabel(token.getValue())) continue;
            String string3 = token.getValue() + "_M" + l;
            string = this.replaceToken(string, token, string3);
        }
        return string;
    }

    private boolean tokenIsMacroLabel(String string) {
        return Collections.binarySearch(this.labels, string) >= 0;
    }

    private String replaceToken(String string, Token token, String string2) {
        String string3 = token.getValue();
        int n = string.indexOf(string3);
        return n < 0 ? string : string.substring(0, n) + string2 + string.substring(n + string3.length());
    }

    public static boolean tokenIsMacroParameter(String string, boolean bl) {
        if (bl && string.length() > 0 && string.charAt(0) == '$' && RegisterFile.getRegister(string) == null && FloatingPointRegisterFile.getRegister(string) == null) {
            return true;
        }
        return string.length() > 1 && string.charAt(0) == '%';
    }

    public void addLabel(String string) {
        this.labels.add(string);
    }

    public void readyForCommit() {
        Collections.sort(this.labels);
    }
}

