/*
 * Decompiled with CFR 0.152.
 */
package rars;

import java.util.ArrayList;
import rars.ErrorList;
import rars.ErrorMessage;
import rars.Globals;
import rars.RISCVprogram;
import rars.Settings;
import rars.assembler.Token;
import rars.assembler.TokenList;
import rars.assembler.TokenTypes;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.Instruction;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterFile;
import rars.util.Binary;
import rars.venus.NumberDisplayBaseChooser;

public class ProgramStatement
implements Comparable<ProgramStatement> {
    private RISCVprogram sourceProgram;
    private String source;
    private String basicAssemblyStatement;
    private String machineStatement;
    private TokenList originalTokenList;
    private TokenList strippedTokenList;
    private BasicStatementList basicStatementList;
    private int[] operands;
    private int numOperands;
    private Instruction instruction;
    private int textAddress;
    private int sourceLine;
    private int binaryStatement;
    private boolean altered;
    private static final String invalidOperator = "<INVALID>";

    public ProgramStatement(RISCVprogram rISCVprogram, String string, TokenList tokenList, TokenList tokenList2, Instruction instruction, int n, int n2) {
        this.sourceProgram = rISCVprogram;
        this.source = string;
        this.originalTokenList = tokenList;
        this.strippedTokenList = tokenList2;
        this.operands = new int[5];
        this.numOperands = 0;
        this.instruction = instruction;
        this.textAddress = n;
        this.sourceLine = n2;
        this.basicAssemblyStatement = null;
        this.basicStatementList = new BasicStatementList();
        this.machineStatement = null;
        this.binaryStatement = 0;
        this.altered = false;
    }

    public ProgramStatement(int n, int n2) {
        this.sourceProgram = null;
        this.binaryStatement = n;
        this.textAddress = n2;
        this.strippedTokenList = null;
        this.originalTokenList = null;
        this.source = "";
        this.basicAssemblyStatement = null;
        this.machineStatement = null;
        BasicInstruction basicInstruction = Globals.instructionSet.findByBinaryCode(n);
        if (basicInstruction == null) {
            this.operands = null;
            this.numOperands = 0;
            this.instruction = null;
        } else {
            this.operands = new int[5];
            this.numOperands = 0;
            this.instruction = basicInstruction;
            String string = basicInstruction.getOperationMask();
            BasicInstructionFormat basicInstructionFormat = basicInstruction.getInstructionFormat();
            if (basicInstructionFormat == BasicInstructionFormat.J_FORMAT) {
                this.operands[0] = this.readBinaryCode(string, Instruction.operandMask[0], n);
                this.operands[1] = this.fromJumpImmediate(this.readBinaryCode(string, Instruction.operandMask[1], n));
                this.numOperands = 2;
            } else if (basicInstructionFormat == BasicInstructionFormat.B_FORMAT) {
                this.operands[0] = this.readBinaryCode(string, Instruction.operandMask[0], n);
                this.operands[1] = this.readBinaryCode(string, Instruction.operandMask[1], n);
                this.operands[2] = this.fromBranchImmediate(this.readBinaryCode(string, Instruction.operandMask[2], n));
                this.numOperands = 3;
            } else {
                for (int i = 0; i < 5; ++i) {
                    if (string.indexOf(Instruction.operandMask[i]) == -1) continue;
                    this.operands[i] = this.readBinaryCode(string, Instruction.operandMask[i], n);
                    ++this.numOperands;
                }
            }
        }
        this.altered = false;
        this.basicStatementList = this.buildBasicStatementListFromBinaryCode(n, basicInstruction, this.operands, this.numOperands);
    }

    @Override
    public int compareTo(ProgramStatement programStatement) {
        int n = this.getAddress();
        int n2 = programStatement.getAddress();
        return n < 0 && n2 >= 0 || n >= 0 && n2 < 0 ? n2 : n - n2;
    }

    public void buildBasicStatementFromBasicInstruction(ErrorList errorList) {
        String string;
        Token token = this.strippedTokenList.get(0);
        String string2 = string = token.getValue() + " ";
        this.basicStatementList.addString(string);
        this.numOperands = 0;
        for (int i = 1; i < this.strippedTokenList.size(); ++i) {
            int n;
            token = this.strippedTokenList.get(i);
            TokenTypes tokenTypes = token.getType();
            String string3 = token.getValue();
            if (tokenTypes == TokenTypes.REGISTER_NUMBER) {
                string = string3;
                string2 = string2 + string;
                this.basicStatementList.addString(string);
                try {
                    n = RegisterFile.getRegister(string3).getNumber();
                }
                catch (Exception exception) {
                    errorList.add(new ErrorMessage(this.sourceProgram, token.getSourceLine(), token.getStartPos(), "invalid register name"));
                    return;
                }
                this.operands[this.numOperands++] = n;
            } else if (tokenTypes == TokenTypes.REGISTER_NAME) {
                n = RegisterFile.getRegister(string3).getNumber();
                string = "x" + n;
                string2 = string2 + string;
                this.basicStatementList.addString(string);
                if (n < 0) {
                    errorList.add(new ErrorMessage(this.sourceProgram, token.getSourceLine(), token.getStartPos(), "invalid register name"));
                    return;
                }
                this.operands[this.numOperands++] = n;
            } else if (tokenTypes == TokenTypes.CSR_NAME) {
                Register[] registerArray = ControlAndStatusRegisterFile.getRegisters();
                n = -1;
                for (Register register : registerArray) {
                    if (!register.getName().equals(string3)) continue;
                    n = register.getNumber();
                    break;
                }
                if (n < 0) {
                    errorList.add(new ErrorMessage(this.sourceProgram, token.getSourceLine(), token.getStartPos(), "invalid CSR name"));
                    return;
                }
                string2 = string2 + n;
                this.basicStatementList.addString("" + n);
                this.operands[this.numOperands++] = n;
            } else if (tokenTypes == TokenTypes.FP_REGISTER_NAME) {
                n = FloatingPointRegisterFile.getRegister(string3).getNumber();
                string = "f" + n;
                string2 = string2 + string;
                this.basicStatementList.addString(string);
                if (n < 0) {
                    errorList.add(new ErrorMessage(this.sourceProgram, token.getSourceLine(), token.getStartPos(), "invalid FPU register name"));
                    return;
                }
                this.operands[this.numOperands++] = n;
            } else if (tokenTypes == TokenTypes.ROUNDING_MODE) {
                int n2 = -1;
                if (string3.equals("rne")) {
                    n2 = 0;
                } else if (string3.equals("rtz")) {
                    n2 = 1;
                } else if (string3.equals("rdn")) {
                    n2 = 2;
                } else if (string3.equals("rup")) {
                    n2 = 3;
                } else if (string3.equals("rmm")) {
                    n2 = 4;
                } else if (string3.equals("dyn")) {
                    n2 = 7;
                }
                if (n2 == -1) {
                    errorList.add(new ErrorMessage(this.sourceProgram, token.getSourceLine(), token.getStartPos(), "invalid rounding mode"));
                    return;
                }
                string2 = string2 + string3;
                this.basicStatementList.addString(string3);
                this.operands[this.numOperands++] = n2;
            } else if (tokenTypes == TokenTypes.IDENTIFIER) {
                int n3 = this.sourceProgram.getLocalSymbolTable().getAddressLocalOrGlobal(string3);
                if (n3 == -1) {
                    errorList.add(new ErrorMessage(this.sourceProgram, token.getSourceLine(), token.getStartPos(), "Symbol \"" + string3 + "\" not found in symbol table."));
                    return;
                }
                boolean bl = true;
                if (this.instruction instanceof BasicInstruction) {
                    BasicInstructionFormat basicInstructionFormat = ((BasicInstruction)this.instruction).getInstructionFormat();
                    if (basicInstructionFormat == BasicInstructionFormat.B_FORMAT) {
                        if ((n3 -= this.textAddress) >= 4096 || n3 < -4096) {
                            errorList.add(new ErrorMessage(this.sourceProgram, this.sourceLine, 0, "Branch target word address beyond 12-bit range"));
                            return;
                        }
                        bl = false;
                    } else if (basicInstructionFormat == BasicInstructionFormat.J_FORMAT) {
                        if ((n3 -= this.textAddress) >= 0x100000 || n3 < -1048576) {
                            errorList.add(new ErrorMessage(this.sourceProgram, this.sourceLine, 0, "Jump target word address beyond 20-bit range"));
                            return;
                        }
                        bl = false;
                    }
                }
                string2 = string2 + n3;
                if (bl) {
                    this.basicStatementList.addAddress(n3);
                } else {
                    this.basicStatementList.addValue(n3);
                }
                this.operands[this.numOperands++] = n3;
            } else if (tokenTypes == TokenTypes.INTEGER_5 || tokenTypes == TokenTypes.INTEGER_6 || tokenTypes == TokenTypes.INTEGER_12 || tokenTypes == TokenTypes.INTEGER_12U || tokenTypes == TokenTypes.INTEGER_20 || tokenTypes == TokenTypes.INTEGER_32) {
                int n4 = Binary.stringToInt(string3);
                string2 = string2 + n4;
                if (tokenTypes == TokenTypes.INTEGER_5) {
                    this.basicStatementList.addShortValue(n4);
                } else {
                    this.basicStatementList.addValue(n4);
                }
                this.operands[this.numOperands++] = n4;
            } else {
                string = string3;
                string2 = string2 + string;
                this.basicStatementList.addString(string);
            }
            if (i >= this.strippedTokenList.size() - 1) continue;
            TokenTypes tokenTypes2 = this.strippedTokenList.get(i + 1).getType();
            if (tokenTypes == TokenTypes.LEFT_PAREN || tokenTypes == TokenTypes.RIGHT_PAREN || tokenTypes2 == TokenTypes.LEFT_PAREN || tokenTypes2 == TokenTypes.RIGHT_PAREN) continue;
            string = ",";
            string2 = string2 + string;
            this.basicStatementList.addString(string);
        }
        this.basicAssemblyStatement = string2;
    }

    public void buildMachineStatementFromBasicStatement(ErrorList errorList) {
        if (!(this.instruction instanceof BasicInstruction)) {
            errorList.add(new ErrorMessage(this.sourceProgram, this.sourceLine, 0, "INTERNAL ERROR: pseudo-instruction expansion contained a pseudo-instruction"));
            return;
        }
        this.machineStatement = ((BasicInstruction)this.instruction).getOperationMask();
        BasicInstructionFormat basicInstructionFormat = ((BasicInstruction)this.instruction).getInstructionFormat();
        if (basicInstructionFormat == BasicInstructionFormat.J_FORMAT) {
            this.insertBinaryCode(this.operands[0], Instruction.operandMask[0], errorList);
            this.insertBinaryCode(this.toJumpImmediate(this.operands[1]), Instruction.operandMask[1], errorList);
        } else if (basicInstructionFormat == BasicInstructionFormat.B_FORMAT) {
            this.insertBinaryCode(this.operands[0], Instruction.operandMask[0], errorList);
            this.insertBinaryCode(this.operands[1], Instruction.operandMask[1], errorList);
            this.insertBinaryCode(this.toBranchImmediate(this.operands[2]), Instruction.operandMask[2], errorList);
        } else {
            for (int i = 0; i < this.numOperands; ++i) {
                this.insertBinaryCode(this.operands[i], Instruction.operandMask[i], errorList);
            }
        }
        this.binaryStatement = Binary.binaryStringToInt(this.machineStatement);
    }

    private int toJumpImmediate(int n) {
        return (n >>= 1) & 0x80000 | (n & 0x3FF) << 9 | (n & 0x400) >> 2 | (n & 0x7F800) >> 11;
    }

    private int fromJumpImmediate(int n) {
        int n2 = n & 0x80000 | (n & 0x7FE00) >> 9 | (n & 0x100) << 2 | (n & 0xFF) << 11;
        return n2 << 12 >> 11;
    }

    private int toBranchImmediate(int n) {
        return (n >>= 1) & 0x800 | (n & 0x3FF) << 1 | (n & 0x400) >> 10;
    }

    private int fromBranchImmediate(int n) {
        int n2 = n & 0x800 | (n & 0x7FE) >> 1 | (n & 1) << 10;
        return n2 << 20 >> 19;
    }

    public String toString() {
        int n;
        String string = "                               ";
        String string2 = "[" + this.textAddress + "]";
        if (this.basicAssemblyStatement != null) {
            n = this.basicAssemblyStatement.indexOf(" ");
            string2 = string2 + string.substring(0, 16 - string2.length()) + this.basicAssemblyStatement.substring(0, n);
            string2 = string2 + string.substring(0, 24 - string2.length()) + this.basicAssemblyStatement.substring(n + 1);
        } else {
            string2 = string2 + string.substring(0, 16 - string2.length()) + "0x" + Integer.toString(this.binaryStatement, 16);
        }
        string2 = string2 + string.substring(0, 40 - string2.length()) + ";  ";
        if (this.operands != null) {
            for (n = 0; n < this.numOperands; ++n) {
                string2 = string2 + Integer.toString(this.operands[n], 16) + " ";
            }
        }
        if (this.machineStatement != null) {
            string2 = string2 + "[" + Binary.binaryStringToHexString(this.machineStatement) + "]";
            string2 = string2 + "  " + this.machineStatement.substring(0, 6) + "|" + this.machineStatement.substring(6, 11) + "|" + this.machineStatement.substring(11, 16) + "|" + this.machineStatement.substring(16, 21) + "|" + this.machineStatement.substring(21, 26) + "|" + this.machineStatement.substring(26, 32);
        }
        return string2;
    }

    public void setBasicAssemblyStatement(String string) {
        this.basicAssemblyStatement = string;
    }

    public void setMachineStatement(String string) {
        this.machineStatement = string;
    }

    public void setBinaryStatement(int n) {
        this.binaryStatement = n;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public RISCVprogram getSourceProgram() {
        return this.sourceProgram;
    }

    public String getSourceFile() {
        return this.sourceProgram == null ? "" : this.sourceProgram.getFilename();
    }

    public String getSource() {
        return this.source;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public String getBasicAssemblyStatement() {
        return this.basicAssemblyStatement;
    }

    public String getPrintableBasicAssemblyStatement() {
        return this.basicStatementList.toString();
    }

    public String getMachineStatement() {
        return this.machineStatement;
    }

    public int getBinaryStatement() {
        return this.binaryStatement;
    }

    public TokenList getOriginalTokenList() {
        return this.originalTokenList;
    }

    public TokenList getStrippedTokenList() {
        return this.strippedTokenList;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public int getAddress() {
        return this.textAddress;
    }

    public int[] getOperands() {
        return this.operands;
    }

    public int getOperand(int n) {
        if (n >= 0 && n < this.numOperands) {
            return this.operands[n];
        }
        return -1;
    }

    private int readBinaryCode(String string, char c, int n) {
        int n2 = 0;
        for (int i = 0; i < 32; ++i) {
            if (string.charAt(i) != c) continue;
            n2 = n2 << 1 | n >> 31 - i & 1;
        }
        return n2;
    }

    private void insertBinaryCode(int n, char c, ErrorList errorList) {
        StringBuilder stringBuilder = new StringBuilder(this.machineStatement);
        int n2 = 0;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != c) continue;
            ++n2;
        }
        if (n2 == 0) {
            errorList.add(new ErrorMessage(this.sourceProgram, this.sourceLine, 0, "INTERNAL ERROR: mismatch in number of operands in statement vs mask"));
            return;
        }
        String string = Binary.intToBinaryString(n, n2);
        int n3 = 0;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != c) continue;
            stringBuilder.setCharAt(i, string.charAt(n3));
            ++n3;
        }
        this.machineStatement = stringBuilder.toString();
    }

    private BasicStatementList buildBasicStatementListFromBinaryCode(int n, BasicInstruction basicInstruction, int[] nArray, int n2) {
        BasicStatementList basicStatementList = new BasicStatementList();
        int n3 = 1;
        if (basicInstruction == null) {
            basicStatementList.addString(invalidOperator);
            return basicStatementList;
        }
        basicStatementList.addString(basicInstruction.getName() + " ");
        for (int i = 0; i < n2; ++i) {
            TokenTypes tokenTypes;
            if (n3 > 1 && n3 < basicInstruction.getTokenList().size() && (tokenTypes = basicInstruction.getTokenList().get(n3).getType()) != TokenTypes.LEFT_PAREN && tokenTypes != TokenTypes.RIGHT_PAREN) {
                basicStatementList.addString(",");
            }
            boolean bl = true;
            while (bl && n3 < basicInstruction.getTokenList().size()) {
                String[] stringArray;
                TokenTypes tokenTypes2 = basicInstruction.getTokenList().get(n3).getType();
                if (tokenTypes2.equals((Object)TokenTypes.LEFT_PAREN)) {
                    basicStatementList.addString("(");
                } else if (tokenTypes2.equals((Object)TokenTypes.RIGHT_PAREN)) {
                    basicStatementList.addString(")");
                } else if (tokenTypes2.toString().contains("REGISTER")) {
                    stringArray = tokenTypes2.toString().contains("FP_REGISTER") ? "f" : "x";
                    basicStatementList.addString((String)stringArray + nArray[i]);
                    bl = false;
                } else if (tokenTypes2.equals((Object)TokenTypes.INTEGER_12)) {
                    basicStatementList.addValue(nArray[i] << 20 >> 20);
                    bl = false;
                } else if (tokenTypes2.equals((Object)TokenTypes.ROUNDING_MODE)) {
                    stringArray = new String[]{"rne", "rtz", "rdn", "rup", "rmm", "invalid", "invalid", "dyn"};
                    String string = "invalid";
                    if (nArray[i] >= 0 && nArray[i] < 8) {
                        string = stringArray[nArray[i]];
                    }
                    basicStatementList.addString(string);
                    bl = false;
                } else {
                    basicStatementList.addValue(nArray[i]);
                    bl = false;
                }
                ++n3;
            }
        }
        while (n3 < basicInstruction.getTokenList().size()) {
            TokenTypes tokenTypes = basicInstruction.getTokenList().get(n3).getType();
            if (tokenTypes.equals((Object)TokenTypes.LEFT_PAREN)) {
                basicStatementList.addString("(");
            } else if (tokenTypes.equals((Object)TokenTypes.RIGHT_PAREN)) {
                basicStatementList.addString(")");
            }
            ++n3;
        }
        return basicStatementList;
    }

    private class BasicStatementList {
        private ArrayList<ListElement> list = new ArrayList();

        BasicStatementList() {
        }

        void addString(String string) {
            this.list.add(new ListElement(0, string, 0));
        }

        void addAddress(int n) {
            this.list.add(new ListElement(1, null, n));
        }

        void addValue(int n) {
            this.list.add(new ListElement(2, null, n));
        }

        void addShortValue(int n) {
            this.list.add(new ListElement(3, null, n));
        }

        public String toString() {
            int n = Globals.getSettings().getBooleanSetting(Settings.Bool.DISPLAY_ADDRESSES_IN_HEX) ? 16 : 10;
            int n2 = Globals.getSettings().getBooleanSetting(Settings.Bool.DISPLAY_VALUES_IN_HEX) ? 16 : 10;
            StringBuffer stringBuffer = new StringBuffer();
            for (ListElement listElement : this.list) {
                switch (listElement.type) {
                    case 0: {
                        stringBuffer.append(listElement.sValue);
                        break;
                    }
                    case 1: {
                        stringBuffer.append(NumberDisplayBaseChooser.formatNumber(listElement.iValue, n));
                        break;
                    }
                    case 2: {
                        if (n2 == 16) {
                            stringBuffer.append(Binary.intToHexString(listElement.iValue));
                            break;
                        }
                        stringBuffer.append(NumberDisplayBaseChooser.formatNumber(listElement.iValue, n2));
                        break;
                    }
                    case 3: {
                        stringBuffer.append(listElement.iValue);
                        break;
                    }
                }
            }
            return stringBuffer.toString();
        }

        private class ListElement {
            int type;
            String sValue;
            int iValue;

            ListElement(int n, String string, int n2) {
                this.type = n;
                this.sValue = string;
                this.iValue = n2;
            }
        }
    }
}

