/*
 * Decompiled with CFR 0.152.
 */
package rars;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import rars.AssemblyException;
import rars.Globals;
import rars.Settings;
import rars.SimulationException;
import rars.api.Options;
import rars.api.Program;
import rars.riscv.InstructionSet;
import rars.riscv.dump.DumpFormat;
import rars.riscv.dump.DumpFormatLoader;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryConfiguration;
import rars.riscv.hardware.MemoryConfigurations;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.Simulator;
import rars.util.Binary;
import rars.util.FilenameFinder;
import rars.util.MemoryDump;
import rars.venus.VenusUI;

public class Launch {
    private Options options;
    private boolean gui;
    private boolean simulate;
    private boolean rv64;
    private int displayFormat;
    private boolean verbose;
    private boolean assembleProject;
    private boolean countInstructions;
    private static final String rangeSeparator = "-";
    private static final int memoryWordsPerLine = 4;
    private static final int DECIMAL = 0;
    private static final int HEXADECIMAL = 1;
    private static final int ASCII = 2;
    private ArrayList<String> registerDisplayList;
    private ArrayList<String> memoryDisplayList;
    private ArrayList<String> filenameList;
    private int instructionCount;
    private PrintStream out;
    private ArrayList<String[]> dumpTriples = null;
    private ArrayList<String> programArgumentList;
    private int assembleErrorExitCode;
    private int simulateErrorExitCode;

    public static void main(String[] stringArray) {
        new Launch(stringArray);
    }

    private Launch(String[] stringArray) {
        Globals.initialize();
        this.options = new Options();
        this.gui = stringArray.length == 0;
        this.simulate = true;
        this.displayFormat = 1;
        this.verbose = true;
        this.assembleProject = false;
        this.countInstructions = false;
        this.instructionCount = 0;
        this.assembleErrorExitCode = 0;
        this.simulateErrorExitCode = 0;
        this.registerDisplayList = new ArrayList();
        this.memoryDisplayList = new ArrayList();
        this.filenameList = new ArrayList();
        MemoryConfigurations.setCurrentConfiguration(MemoryConfigurations.getDefaultConfiguration());
        this.out = System.out;
        if (!this.parseCommandArgs(stringArray)) {
            System.exit(Globals.exitCode);
        }
        if (this.gui) {
            this.launchIDE();
        } else {
            System.setProperty("java.awt.headless", "true");
            this.dumpSegments(this.runCommand());
            System.exit(Globals.exitCode);
        }
    }

    private void displayAllPostMortem(Program program) {
        this.displayMiscellaneousPostMortem(program);
        this.displayRegistersPostMortem(program);
        this.displayMemoryPostMortem(program.getMemory());
    }

    private void dumpSegments(Program program) {
        if (this.dumpTriples == null || program == null) {
            return;
        }
        for (String[] stringArray : this.dumpTriples) {
            Object object;
            File file = new File(stringArray[2]);
            Integer[] integerArray = MemoryDump.getSegmentBounds(stringArray[0]);
            if (integerArray == null) {
                try {
                    object = this.checkMemoryAddressRange(stringArray[0]);
                    integerArray = new Integer[]{Binary.stringToInt(object[0]), Binary.stringToInt(object[1])};
                }
                catch (NumberFormatException numberFormatException) {
                    integerArray = null;
                }
                catch (NullPointerException nullPointerException) {
                    integerArray = null;
                }
            }
            if (integerArray == null) {
                this.out.println("Error while attempting to save dump, segment/address-range " + stringArray[0] + " is invalid!");
                continue;
            }
            object = DumpFormatLoader.findDumpFormatGivenCommandDescriptor(stringArray[1]);
            if (object == null) {
                this.out.println("Error while attempting to save dump, format " + stringArray[1] + " was not found!");
                continue;
            }
            try {
                int n = program.getMemory().getAddressOfFirstNull(integerArray[0], integerArray[1]) - 4;
                if (n < integerArray[0]) {
                    this.out.println("This segment has not been written to, there is nothing to dump.");
                    continue;
                }
                object.dumpMemoryRange(file, integerArray[0], n, program.getMemory());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.out.println("Error while attempting to save dump, file " + file + " was not found!");
            }
            catch (AddressErrorException addressErrorException) {
                this.out.println("Error while attempting to save dump, file " + file + "!  Could not access address: " + addressErrorException.getAddress() + "!");
            }
            catch (IOException iOException) {
                this.out.println("Error while attempting to save dump, file " + file + "!  Disk IO failed!");
            }
        }
    }

    private void launchIDE() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VenusUI("RARS 1.6", Launch.this.filenameList);
            }
        });
    }

    private boolean parseCommandArgs(String[] stringArray) {
        String string = "nc";
        String string2 = "me";
        boolean bl = true;
        boolean bl2 = false;
        this.programArgumentList = null;
        if (stringArray.length == 0) {
            return true;
        }
        this.processDisplayMessagesToErrSwitch(stringArray, string2);
        this.displayCopyright(stringArray, string);
        if (stringArray.length == 1 && stringArray[0].equals("h")) {
            this.displayHelp();
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (bl2) {
                if (this.programArgumentList == null) {
                    this.programArgumentList = new ArrayList();
                }
                this.programArgumentList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("pa")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].toLowerCase().equals(string2) || stringArray[i].toLowerCase().equals(string)) continue;
            if (stringArray[i].toLowerCase().equals("dump")) {
                if (stringArray.length <= i + 3) {
                    this.out.println("Dump command line argument requires a segment, format and file name.");
                    bl = false;
                    continue;
                }
                if (this.dumpTriples == null) {
                    this.dumpTriples = new ArrayList();
                }
                this.dumpTriples.add(new String[]{stringArray[++i], stringArray[++i], stringArray[++i]});
                continue;
            }
            if (stringArray[i].toLowerCase().equals("mc")) {
                MemoryConfiguration memoryConfiguration;
                if ((memoryConfiguration = MemoryConfigurations.getConfigurationByName((String)(stringArray2 = stringArray[++i]))) == null) {
                    this.out.println("Invalid memory configuration: " + (String)stringArray2);
                    bl = false;
                    continue;
                }
                MemoryConfigurations.setCurrentConfiguration(memoryConfiguration);
                continue;
            }
            if (stringArray[i].toLowerCase().indexOf("ae") == 0) {
                stringArray2 = stringArray[i].substring(2);
                try {
                    this.assembleErrorExitCode = Integer.decode((String)stringArray2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (stringArray[i].toLowerCase().indexOf("se") == 0) {
                stringArray2 = stringArray[i].substring(2);
                try {
                    this.simulateErrorExitCode = Integer.decode((String)stringArray2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (stringArray[i].toLowerCase().equals("d")) {
                Globals.debug = true;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("a")) {
                this.simulate = false;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("ad") || stringArray[i].toLowerCase().equals("da")) {
                Globals.debug = true;
                this.simulate = false;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("p")) {
                this.assembleProject = true;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("dec")) {
                this.displayFormat = 0;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("g")) {
                this.gui = true;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("hex")) {
                this.displayFormat = 1;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("ascii")) {
                this.displayFormat = 2;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("b")) {
                this.verbose = false;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("np") || stringArray[i].toLowerCase().equals("ne")) {
                this.options.pseudo = false;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("we")) {
                this.options.warningsAreErrors = true;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("sm")) {
                this.options.startAtMain = true;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("smc")) {
                this.options.selfModifyingCode = true;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("rv64")) {
                this.rv64 = true;
                continue;
            }
            if (stringArray[i].toLowerCase().equals("ic")) {
                this.countInstructions = true;
                continue;
            }
            if (new File(stringArray[i]).exists()) {
                this.filenameList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].indexOf("x") == 0) {
                if (RegisterFile.getRegister(stringArray[i]) == null && FloatingPointRegisterFile.getRegister(stringArray[i]) == null) {
                    this.out.println("Invalid Register Name: " + stringArray[i]);
                    continue;
                }
                this.registerDisplayList.add(stringArray[i]);
                continue;
            }
            if (RegisterFile.getRegister(stringArray[i]) != null || FloatingPointRegisterFile.getRegister(stringArray[i]) != null || ControlAndStatusRegisterFile.getRegister(stringArray[i]) != null) {
                this.registerDisplayList.add(stringArray[i]);
                continue;
            }
            try {
                Integer.decode(stringArray[i]);
                this.options.maxSteps = Integer.decode(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    stringArray2 = this.checkMemoryAddressRange(stringArray[i]);
                    this.memoryDisplayList.add(stringArray2[0]);
                    this.memoryDisplayList.add(stringArray2[1]);
                    continue;
                }
                catch (NumberFormatException numberFormatException2) {
                    this.out.println("Invalid/unaligned address or invalid range: " + stringArray[i]);
                    bl = false;
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    this.out.println("Invalid Command Argument: " + stringArray[i]);
                    bl = false;
                }
            }
        }
        return bl;
    }

    private Program runCommand() {
        Object object;
        Object object2;
        ArrayList<String> arrayList;
        if (this.filenameList.size() == 0) {
            return null;
        }
        Globals.getSettings().setBooleanSettingNonPersistent(Settings.Bool.RV64_ENABLED, this.rv64);
        InstructionSet.rv64 = this.rv64;
        Globals.instructionSet.populate();
        File file = new File(this.filenameList.get(0)).getAbsoluteFile();
        if (this.assembleProject) {
            arrayList = FilenameFinder.getFilenameList(file.getParent(), Globals.fileExtensions);
            if (this.filenameList.size() > 1) {
                this.filenameList.remove(0);
                object2 = FilenameFinder.getFilenameList(this.filenameList, FilenameFinder.MATCH_ALL_EXTENSIONS);
                block4: for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                    for (int j = 0; j < arrayList.size(); ++j) {
                        if (!arrayList.get(j).equals(((ArrayList)object2).get(i))) continue;
                        ((ArrayList)object2).remove(i);
                        --i;
                        continue block4;
                    }
                }
                arrayList.addAll((Collection<String>)object2);
            }
        } else {
            arrayList = FilenameFinder.getFilenameList(this.filenameList, FilenameFinder.MATCH_ALL_EXTENSIONS);
        }
        object2 = new Program(this.options);
        try {
            if (Globals.debug) {
                this.out.println("---  TOKENIZING & ASSEMBLY BEGINS  ---");
            }
            if ((object = ((Program)object2).assemble(arrayList, file.getAbsolutePath())) != null && object.warningsOccurred()) {
                this.out.println(object.generateWarningReport());
            }
        }
        catch (AssemblyException assemblyException) {
            Globals.exitCode = this.assembleErrorExitCode;
            this.out.println(assemblyException.errors().generateErrorAndWarningReport());
            this.out.println("Processing terminated due to errors.");
            return null;
        }
        ((Program)object2).setup(this.programArgumentList, null);
        if (this.simulate) {
            if (Globals.debug) {
                this.out.println("--------  SIMULATION BEGINS  -----------");
            }
            try {
                while (true) {
                    if ((object = ((Program)object2).simulate()) == Simulator.Reason.MAX_STEPS) {
                        this.out.println("\nProgram terminated when maximum step limit " + this.options.maxSteps + " reached.");
                        break;
                    }
                    if (object == Simulator.Reason.CLIFF_TERMINATION) {
                        this.out.println("\nProgram terminated by dropping off the bottom.");
                        break;
                    }
                    if (object == Simulator.Reason.NORMAL_TERMINATION) {
                        this.out.println("\nProgram terminated by calling exit");
                        break;
                    }
                    assert (object == Simulator.Reason.BREAKPOINT) : "Internal error: All cases other than breakpoints should be handled already";
                    this.displayAllPostMortem((Program)object2);
                }
            }
            catch (SimulationException simulationException) {
                Globals.exitCode = this.simulateErrorExitCode;
                this.out.println(simulationException.error().generateReport());
                this.out.println("Simulation terminated due to errors.");
            }
            this.displayAllPostMortem((Program)object2);
        }
        if (Globals.debug) {
            this.out.println("\n--------  ALL PROCESSING COMPLETE  -----------");
        }
        return object2;
    }

    private String[] checkMemoryAddressRange(String string) throws NumberFormatException {
        String[] stringArray = null;
        if (!(string.indexOf(rangeSeparator) <= 0 || string.indexOf(rangeSeparator) >= string.length() - 1 || Binary.stringToInt((stringArray = new String[]{string.substring(0, string.indexOf(rangeSeparator)), string.substring(string.indexOf(rangeSeparator) + 1)})[0]) <= Binary.stringToInt(stringArray[1]) && Memory.wordAligned(Binary.stringToInt(stringArray[0])) && Memory.wordAligned(Binary.stringToInt(stringArray[1])))) {
            throw new NumberFormatException();
        }
        return stringArray;
    }

    private void displayMiscellaneousPostMortem(Program program) {
        if (this.countInstructions) {
            this.out.println("\n" + program.getRegisterValue("cycle"));
        }
    }

    private void displayRegistersPostMortem(Program program) {
        for (String string : this.registerDisplayList) {
            if (FloatingPointRegisterFile.getRegister(string) != null) {
                int n = program.getRegisterValue(string);
                float f = Float.intBitsToFloat(n);
                if (this.verbose) {
                    this.out.print(string + "\t");
                }
                if (this.displayFormat == 1) {
                    this.out.println(Binary.intToHexString(n));
                    continue;
                }
                if (this.displayFormat == 0) {
                    this.out.println(f);
                    continue;
                }
                this.out.println(Binary.intToAscii(n));
                continue;
            }
            if (ControlAndStatusRegisterFile.getRegister(string) != null) {
                this.out.print(string + "\t");
                this.out.println(this.formatIntForDisplay((int)ControlAndStatusRegisterFile.getRegister(string).getValue()));
                continue;
            }
            if (!this.verbose) continue;
            this.out.print(string + "\t");
            this.out.println(this.formatIntForDisplay((int)RegisterFile.getRegister(string).getValue()));
        }
    }

    private String formatIntForDisplay(int n) {
        String string;
        switch (this.displayFormat) {
            case 0: {
                string = "" + n;
                break;
            }
            case 1: {
                string = Binary.intToHexString(n);
                break;
            }
            case 2: {
                string = Binary.intToAscii(n);
                break;
            }
            default: {
                string = Binary.intToHexString(n);
            }
        }
        return string;
    }

    private void displayMemoryPostMortem(Memory memory) {
        Iterator<String> iterator = this.memoryDisplayList.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            try {
                n = Binary.stringToInt(iterator.next());
                n2 = Binary.stringToInt(iterator.next());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n3 = 0;
            for (int i = n; i <= n2 && (i >= 0 || n2 <= 0); i += 4) {
                if (n3 % 4 == 0) {
                    this.out.print(n3 > 0 ? "\n" : "");
                    if (this.verbose) {
                        this.out.print("Mem[" + Binary.intToHexString(i) + "]\t");
                    }
                }
                try {
                    Integer n4;
                    int n5 = Memory.inTextSegment(i) ? ((n4 = memory.getRawWordOrNull(i)) == null ? 0 : n4) : memory.getWord(i);
                    this.out.print(this.formatIntForDisplay(n5) + "\t");
                }
                catch (AddressErrorException addressErrorException) {
                    this.out.print("Invalid address: " + i + "\t");
                }
                ++n3;
            }
            this.out.println();
        }
    }

    private void processDisplayMessagesToErrSwitch(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.toLowerCase().equals(string)) continue;
            this.out = System.err;
            return;
        }
    }

    private void displayCopyright(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.toLowerCase().equals(string)) continue;
            return;
        }
        this.out.println("RARS 1.6  Copyright " + Globals.copyrightYears + " " + Globals.copyrightHolders + "\n");
    }

    private void displayHelp() {
        String[] stringArray = MemoryDump.getSegmentNames();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            string = string + ", ";
        }
        ArrayList<DumpFormat> arrayList = DumpFormatLoader.getDumpFormats();
        String string2 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string2 = string2 + arrayList.get(i).getCommandDescriptor();
            if (i >= arrayList.size() - 1) continue;
            string2 = string2 + ", ";
        }
        this.out.println("Usage:  Rars  [options] filename [additional filenames]");
        this.out.println("  Valid options (not case sensitive, separate by spaces) are:");
        this.out.println("      a  -- assemble only, do not simulate");
        this.out.println("  ae<n>  -- terminate RARS with integer exit code <n> if an assemble error occurs.");
        this.out.println("  ascii  -- display memory or register contents interpreted as ASCII codes.");
        this.out.println("      b  -- brief - do not display register/memory address along with contents");
        this.out.println("      d  -- display RARS debugging statements");
        this.out.println("    dec  -- display memory or register contents in decimal.");
        this.out.println("   dump <segment> <format> <file> -- memory dump of specified memory segment");
        this.out.println("            in specified format to specified file.  Option may be repeated.");
        this.out.println("            Dump occurs at the end of simulation unless 'a' option is used.");
        this.out.println("            Segment and format are case-sensitive and possible values are:");
        this.out.println("            <segment> = " + string + ", or a range like 0x400000-0x10000000");
        this.out.println("            <format> = " + string2);
        this.out.println("      g  -- force GUI mode");
        this.out.println("      h  -- display this help.  Use by itself with no filename.");
        this.out.println("    hex  -- display memory or register contents in hexadecimal (default)");
        this.out.println("     ic  -- display count of basic instructions 'executed'");
        this.out.println("     mc <config>  -- set memory configuration.  Argument <config> is");
        this.out.println("            case-sensitive and possible values are: Default for the default");
        this.out.println("            32-bit address space, CompactDataAtZero for a 32KB memory with");
        this.out.println("            data segment at address 0, or CompactTextAtZero for a 32KB");
        this.out.println("            memory with text segment at address 0.");
        this.out.println("     me  -- display RARS messages to standard err instead of standard out. ");
        this.out.println("            Can separate messages from program output using redirection");
        this.out.println("     nc  -- do not display copyright notice (for cleaner redirected/piped output).");
        this.out.println("     np  -- use of pseudo instructions and formats not permitted");
        this.out.println("      p  -- Project mode - assemble all files in the same directory as given file.");
        this.out.println("  se<n>  -- terminate RARS with integer exit code <n> if a simulation (run) error occurs.");
        this.out.println("     sm  -- start execution at statement with global label main, if defined");
        this.out.println("    smc  -- Self Modifying Code - Program can write and branch to either text or data segment");
        this.out.println("    rv64 -- Enables 64 bit assembly and executables (Not fully compatible with rv32)");
        this.out.println("    <n>  -- where <n> is an integer maximum count of steps to simulate.");
        this.out.println("            If 0, negative or not specified, there is no maximum.");
        this.out.println(" x<reg>  -- where <reg> is number or name (e.g. 5, t3, f10) of register whose ");
        this.out.println("            content to display at end of run.  Option may be repeated.");
        this.out.println("<reg_name>  -- where <reg_name> is name (e.g. t3, f10) of register whose");
        this.out.println("            content to display at end of run.  Option may be repeated. ");
        this.out.println("<m>-<n>  -- memory address range from <m> to <n> whose contents to");
        this.out.println("            display at end of run. <m> and <n> may be hex or decimal,");
        this.out.println("            must be on word boundary, <m> <= <n>.  Option may be repeated.");
        this.out.println("     pa  -- Program Arguments follow in a space-separated list.  This");
        this.out.println("            option must be placed AFTER ALL FILE NAMES, because everything");
        this.out.println("            that follows it is interpreted as a program argument to be");
        this.out.println("            made available to the program at runtime.");
        this.out.println("If more than one filename is listed, the first is assumed to be the main");
        this.out.println("unless the global statement label 'main' is defined in one of the files.");
        this.out.println("Exception handler not automatically assembled.  Add it to the file list.");
        this.out.println("Options used here do not affect RARS Settings menu values and vice versa.");
    }
}

