/*
 * Decompiled with CFR 0.152.
 */
package rars;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rars.ProgramStatement;
import rars.RISCVprogram;
import rars.assembler.SourceLine;

public class ErrorMessage {
    private boolean isWarning;
    private String filename;
    private int line;
    private int position;
    private String message;
    private String macroExpansionHistory;
    public static final boolean WARNING = true;
    public static final boolean ERROR = false;

    public ErrorMessage(RISCVprogram rISCVprogram, int n, int n2, String string) {
        this(false, rISCVprogram, n, n2, string);
    }

    public ErrorMessage(boolean bl, RISCVprogram rISCVprogram, int n, int n2, String string) {
        this.isWarning = bl;
        if (rISCVprogram == null) {
            this.filename = "";
            this.line = n;
        } else if (rISCVprogram.getSourceLineList() == null) {
            this.filename = rISCVprogram.getFilename();
            this.line = n;
        } else {
            SourceLine sourceLine = rISCVprogram.getSourceLineList().get(n - 1);
            this.filename = sourceLine.getFilename();
            this.line = sourceLine.getLineNumber();
        }
        this.position = n2;
        this.message = string;
        this.macroExpansionHistory = ErrorMessage.getExpansionHistory(rISCVprogram);
    }

    public ErrorMessage(ProgramStatement programStatement, String string) {
        this.isWarning = false;
        this.filename = programStatement.getSourceProgram() == null ? "" : programStatement.getSourceProgram().getFilename();
        this.position = 0;
        this.message = string;
        ArrayList<Integer> arrayList = this.parseMacroHistory(programStatement.getSource());
        if (arrayList.size() == 0) {
            this.line = programStatement.getSourceLine();
            this.macroExpansionHistory = "";
        } else {
            this.line = arrayList.get(0);
            this.macroExpansionHistory = "" + programStatement.getSourceLine();
        }
    }

    private ArrayList<Integer> parseMacroHistory(String string) {
        String string2;
        Pattern pattern = Pattern.compile("<\\d+>");
        Matcher matcher = pattern.matcher(string);
        String string3 = new String(string).trim();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (matcher.find() && string3.indexOf(string2 = matcher.group()) == 0) {
            try {
                int n = Integer.parseInt(string2.substring(1, string2.length() - 1));
                arrayList.add(n);
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            string3 = string3.substring(string2.length()).trim();
        }
        return arrayList;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public int getPosition() {
        return this.position;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public String generateReport() {
        String string = (this.isWarning ? "Warning" : "Error") + " in ";
        if (this.getFilename().length() > 0) {
            string = string + new File(this.getFilename()).getPath();
        }
        if (this.getLine() > 0) {
            string = string + " line " + this.getMacroExpansionHistory() + this.getLine();
        }
        if (this.getPosition() > 0) {
            string = string + " column " + this.getPosition();
        }
        string = string + ": " + this.getMessage() + "\n";
        return string;
    }

    public String getMacroExpansionHistory() {
        if (this.macroExpansionHistory == null || this.macroExpansionHistory.length() == 0) {
            return "";
        }
        return this.macroExpansionHistory + "->";
    }

    private static String getExpansionHistory(RISCVprogram rISCVprogram) {
        if (rISCVprogram == null || rISCVprogram.getLocalMacroPool() == null) {
            return "";
        }
        return rISCVprogram.getLocalMacroPool().getExpansionHistory();
    }
}

