module signext_testbench;
  reg reset_; initial begin reset_=0; #22 reset_=1; #300; $stop; end
  reg clock;  initial clock=0; always #5 clock<=(!clock);
  reg[15:0] X; wire[31:0] Z = SE.y;
  initial begin 
    wait(reset_==1); X<=0; 
    @(posedge clock); X<=16'h0002;
    @(posedge clock); X<=16'h8000;
    @(posedge clock); X<=16'hFFFF;
    @(posedge clock); X<=16'hC000;
    #180
    $finish;
  end
  signext  SE(X, Z);
endmodule

module signext(a, y);
   input [15:0] a; output [31:0] y;
   assign y = {{16{a[15]}}, a};
endmodule
