`timescale 1ns/1ps
module regfile_testbench;
   reg reset_; initial begin reset_=0; #22 reset_=1; #600; $stop; end
   reg clock;  initial clock<=0;   always #5 clock<=(!clock);
   reg [4:0] RS, RT, RD; reg WE3; reg [31:0] WDR;
   wire [31:0] A, B;
   initial begin 
      wait(reset_==1); RS<=32'hXXXXXXXX; RT<=32'hXXXXXXXX; WE3<=0;
      @(posedge clock); RS<=0;  RT<=1;   @(posedge clock); RS<=1;  RT<=2;   @(posedge clock); RS<=2;  RT<=3;   @(posedge clock); RS<=3;  RT<=4;
      @(posedge clock); RS<=4;  RT<=5;   @(posedge clock); RS<=5;  RT<=6;   @(posedge clock); RS<=6;  RT<=7;   @(posedge clock); RS<=7;  RT<=8; 
      @(posedge clock); RS<=8;  RT<=9;   @(posedge clock); RS<=9;  RT<=10;  @(posedge clock); RS<=10; RT<=11;  @(posedge clock); RS<=11; RT<=12;
      @(posedge clock); RS<=12; RT<=13;  @(posedge clock); RS<=13; RT<=14;  @(posedge clock); RS<=14; RT<=15;  @(posedge clock); RS<=15; RT<=16;
      #10 WE3<=1; WDR=32'h12345678;
      @(posedge clock); RD<=0;  WDR<=1;  @(posedge clock); RD<=1;  WDR<=2;  @(posedge clock); RD<=2;  WDR<=3;  @(posedge clock); RD<=3;  WDR<=4;
      @(posedge clock); RD<=4;  WDR<=5;  @(posedge clock); RD<=5;  WDR<=6;  @(posedge clock); RD<=6;  WDR<=7;  @(posedge clock); RD<=7;  WDR<=8; 
      @(posedge clock); RD<=8;  WDR<=9;  @(posedge clock); RD<=9;  WDR<=10; @(posedge clock); RD<=10; WDR<=11; @(posedge clock); RD<=11; WDR<=12;
      @(posedge clock); RD<=12; WDR<=13; @(posedge clock); RD<=13; WDR<=14; @(posedge clock); RD<=14; WDR<=15; @(posedge clock); RD<=15; WDR<=16;
      #10 RS<=32'hXXXXXXXX; RT<=32'hXXXXXXXX; WE3<=0; #10
      @(posedge clock); RS<=0;  RT<=1;   @(posedge clock); RS<=1;  RT<=2;   @(posedge clock); RS<=2;  RT<=3;   @(posedge clock); RS<=3;  RT<=4;
      @(posedge clock); RS<=4;  RT<=5;   @(posedge clock); RS<=5;  RT<=6;   @(posedge clock); RS<=6;  RT<=7;   @(posedge clock); RS<=7;  RT<=8; 
      @(posedge clock); RS<=8;  RT<=9;   @(posedge clock); RS<=9;  RT<=10;  @(posedge clock); RS<=10; RT<=11;  @(posedge clock); RS<=11; RT<=12;
      @(posedge clock); RS<=12; RT<=13;  @(posedge clock); RS<=13; RT<=14;  @(posedge clock); RS<=14; RT<=15;  @(posedge clock); RS<=15; RT<=16;
      #180 $finish;
   end
   regfile MYREGF(clock,WE3,RS,RT,RD,WDR,  A,B);
endmodule
                                                
module regfile(clk, we3, ra1, ra2, wa3, wd3,   rd1, rd2);
   input clk,we3; input[4:0] ra1, ra2, wa3; input[31:0] wd3;
   output[31:0] rd1, rd2; reg[31:0] rd1, rd2;
   reg[31:0] rf[0:31];
   // three ported register file: read two ports combinationally
   // write third port on falling edge of clk; register 0 hardwired to 0
   always @(negedge clk) if (we3) rf[wa3] <= wd3;
   always @(ra1) rd1 <= (ra1 != 0) ? rf[ra1] : 0; 
   always @(ra2) rd2 <= (ra2 != 0) ? rf[ra2] : 0;
endmodule

