`timescale 1ns/1ps
module imem_testbench;
   reg reset_; initial begin reset_=0; #22 reset_=1; #300; $stop; end
   reg clock;  initial clock=0; always #5 clock<=(!clock);
   reg [5:0] IP;
   wire [31:0] IR;
   initial begin 
      wait(reset_==1); IP<=32'hXXXXXXXX;
      @(posedge clock); IP<=0; 
      @(posedge clock); IP<=1; 
      @(posedge clock); IP<=2; 
      @(posedge clock); IP<=3; 
      @(posedge clock); IP<=4; 
      @(posedge clock); IP<=5; 
      @(posedge clock); IP<=6; 
      @(posedge clock); IP<=7; 
      @(posedge clock); IP<=8; 
      @(posedge clock); IP<=9; 
      @(posedge clock); IP<=10; 
      @(posedge clock); IP<=11; 
      @(posedge clock); IP<=12; 
      @(posedge clock); IP<=13; 
      @(posedge clock); IP<=14; 
      @(posedge clock); IP<=15; 
      #10 $finish;
   end
   imem MYIMEM(IP,IR);
endmodule

module imem(a, rd);
   input [5:0] a; output [31:0] rd;
   reg [31:0] RAM[0:63];
   initial $readmemh("memfile.dat", RAM);
   assign rd = RAM[a]; // word aligned
endmodule 
 
