`timescale 1ns/1ps
module dmem_testbench;
   reg reset_; initial begin reset_=0; #22 reset_=1; #600; $stop; end
   reg clock;  initial clock<=0;   always #5 clock<=(!clock);
   reg [5:0] MAR; reg WE; reg [31:0] WDR;
   wire [31:0] RDR;
   initial begin 
      wait(reset_==1); MAR<=32'hXXXXXXXX; WE<=0;
      @(posedge clock); MAR<=0;  @(posedge clock); MAR<=4;  @(posedge clock); MAR<=8;  @(posedge clock); MAR<=12; 
      @(posedge clock); MAR<=16; @(posedge clock); MAR<=20; @(posedge clock); MAR<=24; @(posedge clock); MAR<=28; 
      @(posedge clock); MAR<=32; @(posedge clock); MAR<=36; @(posedge clock); MAR<=40; @(posedge clock); MAR<=44; 
      @(posedge clock); MAR<=48; @(posedge clock); MAR<=52; @(posedge clock); MAR<=56; @(posedge clock); MAR<=60; 
      #10 WE<=1; WDR=32'h12345678;
      @(posedge clock); MAR<=0;  WDR<=1;  @(posedge clock); MAR<=4;  WDR<=2;  @(posedge clock); MAR<=8;  WDR<=3;  @(posedge clock); MAR<=12; WDR<=4;
      @(posedge clock); MAR<=16; WDR<=5;  @(posedge clock); MAR<=20; WDR<=6;  @(posedge clock); MAR<=24; WDR<=7;  @(posedge clock); MAR<=28; WDR<=8;
      @(posedge clock); MAR<=32; WDR<=9;  @(posedge clock); MAR<=36; WDR<=10; @(posedge clock); MAR<=40; WDR<=11; @(posedge clock); MAR<=44; WDR<=12;
      @(posedge clock); MAR<=48; WDR<=13; @(posedge clock); MAR<=52; WDR<=14; @(posedge clock); MAR<=56; WDR<=15; @(posedge clock); MAR<=60; WDR<=16;
      #10 MAR<=32'hXXXXXXXX; WE<=0; #10
      @(posedge clock); MAR<=0;  @(posedge clock); MAR<=4;  @(posedge clock); MAR<=8;  @(posedge clock); MAR<=12; 
      @(posedge clock); MAR<=16; @(posedge clock); MAR<=20; @(posedge clock); MAR<=24; @(posedge clock); MAR<=28; 
      @(posedge clock); MAR<=32; @(posedge clock); MAR<=36; @(posedge clock); MAR<=40; @(posedge clock); MAR<=44; 
      @(posedge clock); MAR<=48; @(posedge clock); MAR<=52; @(posedge clock); MAR<=56; @(posedge clock); MAR<=60; 
      #10 $finish;
   end
   dmem MYDMEM(clock,WE,MAR,WDR,RDR);
endmodule

module dmem(clk, we, a, wd,   rd);
   input clk, we;  input[7:0] a; input[31:0] wd; output[31:0] rd;
   reg [31:0] RAM2[0:63];
   assign rd = RAM2[a[7:2]]; // word aligned
   always @(posedge clk)
   if (we) RAM2[a[7:2]] <= wd;
endmodule
