`timescale 1ns/1ps
module alu_testbench;
   reg reset_; initial begin reset_=0; #22 reset_=1; #600; $stop; end
   reg clock;  initial clock<=0;   always #5 clock<=(!clock);
   reg [31:0] A, B; reg [2:0] ALUOperation;
   wire [31:0] Result; wire Zero, Overflow;
   initial begin 
      wait(reset_==1); 
      // Addition unit testing 
      ALUOperation<=3'b010; 
      @(posedge clock); A=32'h00000DEF; B=32'h00000ABC; // Should output 000018AB
      @(posedge clock); A=32'h00001234; B=32'h00000105; // Should output 00001339
      @(posedge clock); A=32'h7FFFFFFF; B=32'h00000001; // Should output 80000000, overflow, negative
      // AND unit testing 
      ALUOperation<=3'b000; 
      @(posedge clock); A=32'h00000DEF; B=32'h00000ABC; // Should output 000008AC	
      @(posedge clock); A=32'h00001234; B=32'h00000105; // Should output 00000004
      @(posedge clock); A=32'h80000000; B=32'h00000001; // Should output 00000000	
      // OR unit testing 
      ALUOperation<=3'b001; 
      @(posedge clock); A=32'h00000DEF; B=32'h00000ABC; // Should output 00000FFF	
      @(posedge clock); A=32'h00001234; B=32'h00000105; // Should output 00001335
      @(posedge clock); A=32'h80000000; B=32'h00000001; // Should output 80000001	
      // Subtraction unit testing 
      ALUOperation<=3'b110; 
      @(posedge clock); A=32'h00000DEF; B=32'h00000ABC; // Should output 00000333	
      @(posedge clock); A=32'h00001234; B=32'h00000105; // Should output 0000112F
      @(posedge clock); A=32'h80000000; B=32'h00000001; // Should output 7FFFFFFF, overflow
      // Set Less Than unit testing 
      ALUOperation<=3'b111; 
      @(posedge clock); A=32'h00000000; B=32'h00000DEF; // Should output 00000001
      @(posedge clock); A=32'h00001234; B=32'h00000105; // Should output 00000000
      #180 $finish;
   end
   alu MYALU(A,B,ALUOperation,  Result, Zero, Overflow);
endmodule

module alu(a, b, aluctrl,  aluout, zero, overflow);
   input[31:0] a, b; input[2:0] aluctrl;
   output[31:0] aluout; output zero, overflow; reg[31:0] aluout;
   assign zero = (aluout==0); //v------ delay to av. inf. speed loops
   always @(aluctrl or a or b) #0.1 //re-evaluate if these change
      casex (aluctrl)
         0: aluout <= a & b;
         1: aluout <= a | b;
         2: aluout <= a + b;
         6: aluout <= a - b;
         7: aluout <= a<b ? 1:0;
         default: aluout<=0; //default to 0, should not happen
      endcase
endmodule





