`timescale 1ns/1ps
module adder_testbench;
   reg reset_; initial begin reset_=0; #22 reset_=1; #600; $stop; end
   reg clock;  initial clock<=0;   always #5 clock<=(!clock);
   reg [31:0] A, B;
   wire [31:0] Result;
   initial begin 
      wait(reset_==1); 
      // Addition unit testing 
      @(posedge clock); A=32'h00000DEF; B=32'h00000ABC; // Should output 000018AB
      @(posedge clock); A=32'h00001234; B=32'h00000105; // Should output 00001339
      @(posedge clock); A=32'h7FFFFFFF; B=32'h00000001; // Should output 80000000, overflow, negative
      #180 $finish;
   end
   adder MYADD(A,B,  Result);
endmodule

module adder(a, b,  aluout);
   input[31:0] a, b;
   output[31:0] aluout;
   assign aluout=a+b;
endmodule
