//testbench


`timescale 1ns/1ps

module TopLevel;
   reg clock; 
   reg reset_;
   wire[3:0] Q;
   always #10 clock <= (!clock);
   initial begin 
       $display ("time, \t clock, \t reset_, \t QQQQQ");
       $monitor ("%g, \t %b, \t %b, \t %b",$time, clock, reset_,Q);
       reset_=1'b1;
       clock =0; 
       #5 reset_ = 1'b0;
       #20 reset_ = 1'b1;
       #600 $finish;
    end
    
    reg T; initial begin T=1; #650 T=0; end
    SerialCarryCounter src(Q,T,clock,reset_);
    //debug

    wire q0=src.q0, q1=src.q1, q2=src.q2, q3=src.q3;
    wire[3:0] q={src.q3,src.q2,src.q1,src.q0};

endmodule

//Flip-Flop T sensibile al fronte di discesa con riporto

module FFTn(q,tin,tout,clock,reset_);
   input clock,reset_;
   input tin;
   output q,tout;
   reg STAR;
   parameter S0=0, S1=1;
   assign q=(STAR==S0)?0:1;
   assign tout = tin & q; 
   always @(reset_==0) #1 STAR <= S0;
   always @(negedge clock) if (reset_==1) #3
      casex(STAR)
          S0: STAR <= (tin==0)?S0:S1;
          S1: STAR <= (tin==1)?S0:S1;
      endcase
endmodule


module SerialCarryCounter(Q,T,clock,reset_);
   input clock,reset_,T;
   wire q0,q1,q2,q3,to0,to1,to2,to3;
   reg[3:0] Q1;
   output[3:0] Q; assign Q=Q1;
   
   FFTn sc0(q0, T,to0,clock,reset_);
   FFTn sc1(q1, to0,to1,clock,reset_);
   FFTn sc2(q2, to1,to2,clock,reset_);
   FFTn sc3(q3, to2,to3,clock,reset_);

//bufferizziamo in un registro per l'output

always @(negedge clock)
   begin
       Q1[0] <=q0;
       Q1[1] <=q1;
       Q1[2] <=q2;
       Q1[3] <=q3;
   end
endmodule






