#!/bin/bash

echo $0
testdate1="${0##*run_}"
testdate2="${testdate1%.sh}"
echo "TEST: $testdate2"

testprog="prog_$testdate2"

cat <<EOF >$testprog
#! 1
#R 1 1000
#R 4 4000
#R 5 5000
#R 6 6000
36  3  4  2  # LW
36  7  5  2  # LW
24  7  7  3  # MUL
8   1  1  -1 # ADDI
44  7  6  2  # SW
8   2  2  8  # ADDI
5   1  0  -7 # BNE
EOF


cmd="./freess -exe $testprog -iw 4 -wins 16 -pregs 24 -robs 99 -lqs 3 -sqs 3 -llat 2 -afu 1 $*"
echo "$cmd"
$cmd
