`timescale 1ns/1ps
module sl2_testbench;
  reg reset_; initial begin reset_=0; #22 reset_=1; #300; $stop; end
  reg clock;  initial clock=0; always #5 clock<=(!clock);
  reg[31:0] X; wire[31:0] Z = MYSL2.y;
  initial begin 
    wait(reset_==1); X<=0; 
    @(posedge clock); X<=32'h0000_0002;
    @(posedge clock); X<=32'h8000_0000;
    @(posedge clock); X<=32'hFFFF_0000;
    @(posedge clock); X<=32'hC000_0000;
    #180
    $finish;
  end
  sl2 MYSL2(X, Z);
endmodule

module sl2(a, y); // shift left by 2
  input [31:0] a; output [31:0] y;
   assign y = {a[29:0], 2'b00};
endmodule


