`timescale 1ns/1ps
module flopr_testbench;
 reg reset_; initial begin reset_=0; #22 reset_=1; #300; $stop; end
 reg clock;  initial clock=0; always #5 clock<=(!clock);
 reg[5:0] X; wire[5:0] Z  =MYF6.q;
 reg[7:0] D; wire[7:0] Q=MYF8.q;
 initial begin 
 wait(reset_==1); X<=0; D<=0; 
 @(posedge clock); X<=6'h02; D<=8'h10;
 @(posedge clock); X<=6'h3F; D<=0;
 @(posedge clock); X<=6'h2E; D<=8'h1A;
 @(posedge clock); X<=6'h1A; D<=8'h3A;
 #180  $finish;
 end
 flopr #(6) MYF6(clock, reset_, X, Z);
 flopr      MYF8(clock, reset_, D, Q);
endmodule

module flopr (clk, reset_, d, q);
   parameter WIDTH = 8;
   input  [WIDTH-1:0] d; input clk, reset_;
   output [WIDTH-1:0] q; reg [WIDTH-1:0] q;
   always @(posedge clk) // posedge reset)
      #1.1 if (!reset_) q <= 0; //delay inserted to avoid infinite speed loops
      else q <= d;
endmodule

