`timescale 1ns/1ps
module datapath_testbench;
   reg reset_; initial begin reset_=0; #22 reset_=1; #600; $stop; end
   reg clock;  initial clock<=0;   always #5 clock<=(!clock);
   reg memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite;
   reg[2:0] alucontrol; reg [31:0] instr, readdata;
   wire[8:0] cw; assign cw = {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol};
   wire zero, overflow; wire[31:0] writedata, pc, aluout;
   wire[31:0] A, B, RESULT, SI4, NPC, PC4, PCD, PCQ, PCB, PC; wire A3, RESET; assign A = MYDP.srca, B = MYDP.srcb, A3=MYDP.writereg, RESULT=MYDP.result;
   assign SI4=MYDP.signimmsh, NPC=MYDP.pcnext, PC4=MYDP.pcplus4, PCD=MYDP.pcreg.d, PCQ=MYDP.pcreg.q, PCB=MYDP.pcbranch, PC=MYDP.pc, RESET=MYDP.reset_;
   initial begin 
      wait(reset_==1); 
      // Addition unit testing 
      //                .---this delay is inserted to avoid to create infinite speed loops
      //                v
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000101010; instr<=32'h20020005; //addi $2, $0, 5
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000101010; instr<=32'h2003000C; //addi $3, $0, 12
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000101010; instr<=32'h2067fff7; //addi $7, $3, -9
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000011001; instr<=32'h00e22025; //or   $4, $7, $2
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000011000; instr<=32'h00642824; //and  $5, $3, $4

      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000011010; instr<=32'h00a42820; //add  $5, $5, $4
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000000110; instr<=32'h10a70007; //beq  $5, $7, +7
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000011111; instr<=32'h0064202a; //slt  $4, $3, $4
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b001000110; instr<=32'h10800001; //beq  $4, $0, +1  //taken
//      @(posedge clock); {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000101010; instr<=32'h20050000; //addi $5, $0, 0 //skipped

      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000011111; instr<=32'h00e2202a; //slt  $4, $7, $2
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000011010; instr<=32'h00853820; //add  $7, $4, $5
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b000011110; instr<=32'h00e23822; //sub  $7, $7, $2
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b010100010; instr<=32'hac670044; //sw   $7, 68($3)
      @(posedge clock); #1 {memtoreg,memwrite,pcsrc,alusrc,regdst,regwrite,alucontrol}<= 9'b100101010; instr<=32'h8c020050; readdata<=7; //lw   $2, 80($0)
      #5 $display("R2=%h  (should contain '00000007')",MYDP.rf.rf[2]);
      #10 $finish;
   end
   datapath MYDP(clock, reset_, memtoreg, pcsrc, alusrc, regdst, regwrite, alucontrol, instr, readdata, zero, overflow, pc, aluout, writedata);
endmodule

module adder(a, b,  aluout);
   input[31:0] a, b;
   output[31:0] aluout;
   assign aluout=a+b;
endmodule

module alu(a, b, aluctrl,  aluout, zero, overflow);
   input[31:0] a, b; input[2:0] aluctrl;
   output[31:0] aluout; output zero, overflow; reg[31:0] aluout;
   assign zero = (aluout==0); //v------ delay to av. inf. speed loops
   always @(aluctrl or a or b) #0.1 //re-evaluate if these change
      casex (aluctrl)
         0: aluout <= a & b;
         1: aluout <= a | b;
         2: aluout <= a + b;
         6: aluout <= a - b;
         7: aluout <= a<b ? 1:0;
         default: aluout<=0; //default to 0, should not happen
      endcase
endmodule

module flopr (clk, reset_, d, q);
   parameter WIDTH = 8;
   input  [WIDTH-1:0] d; input clk, reset_;
   output [WIDTH-1:0] q; reg [WIDTH-1:0] q;
   always @(posedge clk) // posedge reset)
      #1.1 if (!reset_) q <= 0; //delay inserted to avoid infinite speed loops
      else q <= d;
endmodule

module mux2 (d0, d1, s, y);
  parameter WIDTH = 32;
  input [WIDTH-1:0] d0, d1;
  input s;
  output [WIDTH-1:0] y;
  assign y = s ? d1 : d0;
endmodule

module regfile(clk, we3, ra1, ra2, wa3, wd3,   rd1, rd2);
   input clk,we3; input[4:0] ra1, ra2, wa3; input[31:0] wd3;
   output[31:0] rd1, rd2; reg[31:0] rd1, rd2;
   reg[31:0] rf[0:31];
   // three ported register file: read two ports combinationally
   // write third port on falling edge of clk; register 0 hardwired to 0
   always @(negedge clk) if (we3) rf[wa3] <= wd3;
   always @(ra1) rd1 <= (ra1 != 0) ? rf[ra1] : 0; 
   always @(ra2) rd2 <= (ra2 != 0) ? rf[ra2] : 0;
endmodule

module signext(a, y);
   input [15:0] a; output [31:0] y;
   assign y = {{16{a[15]}}, a};
endmodule

module sl2(a, y); // shift left by 2
  input [31:0] a; output [31:0] y;
   assign y = {a[29:0], 2'b00};
endmodule

module datapath(clk, reset_, memtoreg, pcsrc, alusrc, regdst, regwrite,
                alucontrol, instr, readdata,
                zero, overflow, pc, aluout, writedata);
   input clk, reset_, memtoreg, pcsrc, alusrc, regdst, regwrite;
   input[2:0] alucontrol; input[31:0] instr, readdata;
   output zero, overflow; output[31:0] pc, aluout, writedata;
   wire[4:0] writereg; wire[31:0] pcnext, pcplus4, pcbranch;
   wire[31:0] signimm, signimmsh, srca, srcb, result;
   // next PC logic
   flopr #(32) pcreg(clk, reset_, pcnext, pc);
   adder       pcadd1(pc, 32'b100, pcplus4);
   sl2         immsh(signimm, signimmsh);
   adder       pcadd2(pcplus4, signimmsh, pcbranch);
   mux2 #(32)  pcbrmux(pcplus4, pcbranch, pcsrc, pcnext);
   // register file logic
   regfile     rf(clk,regwrite, instr[25:21], instr[20:16], writereg,
                  result, srca, writedata);
   mux2 #(5)   wrmux(instr[20:16], instr[15:11], regdst, writereg);
   mux2 #(32)  resmux(aluout, readdata, memtoreg, result);
   signext     se(instr[15:0], signimm);
   // ALU logic
   mux2 #(32)  srcbmux(writedata, signimm, alusrc, srcb);
   alu         alu(srca, srcb, alucontrol, aluout, zero, overflow);
endmodule
