`timescale 1ns / 1ps
module controller_testbench;
   reg reset_; initial begin reset_=0; #22 reset_=1; #600; $stop; end
   reg clock;  initial clock<=0;   always #5 clock<=(!clock);
   reg[31:0] IR; reg ZERO; wire[5:0] opcode, funct; wire zero;
   wire memtoreg,memwrite,branch,alusrc,regdst,regwrite;
   wire[2:0] alucontrol;
   wire[9:0] c; //control word
   assign c = {1'b1,memtoreg,memwrite,branch,alusrc,regdst,regwrite,alucontrol};
   initial begin
      @(posedge clock); IR<=32'h20020005; ZERO<=0;
      @(posedge clock); IR<=32'h2003000c; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h2067fff7; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h00e22025; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h00642824; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h00a42820; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h10a70007; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h0064202a; ZERO<=1; $display("c=%b",c); 
      @(posedge clock); IR<=32'h10800001; ZERO<=1; $display("c=%b",c); 
      @(posedge clock); IR<=32'h20050000; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h00e2202a; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h00853820; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h00e23822; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'hac670044; ZERO<=0; $display("c=%b",c); 
      @(posedge clock); IR<=32'h8c020050; ZERO<=0; $display("c=%b",c); 
      #10  $display("c=%b",c);  $finish;
   end
   assign opcode = IR[31:26];
   assign funct  = IR[5:0];
   assign zero   = ZERO;
   controller MYCTRL(opcode,funct,zero,
      memtoreg,memwrite,branch,alusrc,regdst,regwrite,alucontrol);
endmodule

module controller(opcode,funct,zero,  
          memtoreg,memwrite,pcsrc,alusrc,
          regdst,regwrite,alucontrol);
   input[5:0] opcode, funct; input zero;
   output memtoreg,memwrite,pcsrc,
          alusrc,regdst,regwrite;
   output [2:0] alucontrol;
   wire [1:0] aluop; wire branch;

   maindec md(opcode,  memtoreg,memwrite,
               branch,alusrc,regdst,regwrite,aluop);
   aludec ad(funct,aluop,  alucontrol);
   assign pcsrc = branch & zero;
endmodule

module maindec(opcode,  memtoreg,memwrite,branch,
               alusrc,regdst,regwrite,aluop);
   input [5:0] opcode;
   output memtoreg,memwrite,branch,alusrc,regdst, regwrite;
   output [1:0] aluop;
   reg [7:0] controls; initial controls<=0;
   assign {regwrite,regdst,alusrc,branch,
           memwrite,memtoreg,aluop} = controls;
   always @(opcode)
   casex(opcode)
      6'b000000: controls <= 8'b11000010; // RTYPE
      6'b100011: controls <= 8'b10100100; // LW
      6'b101011: controls <= 8'b00101000; // SW
      6'b000100: controls <= 8'b00010001; // BEQ
      6'b001000: controls <= 8'b10100000; // ADDI
      default:   controls <= 8'bxxxxxxxx; // illegal op
   endcase
endmodule

module aludec(funct, aluop, alucontrol);
   input [5:0] funct; input [1:0] aluop; 
   output [2:0] alucontrol;
   reg [2:0] alucontrol;
   always @(aluop or funct)
   casex(aluop)
      2'b00: alucontrol <= 3'b010; // add (for lw/sw/addi)
      2'b01: alucontrol <= 3'b110; // sub (for beq)
      default: casex(funct) // R-type instructions
         6'b100000: alucontrol <= 3'b010; // add
         6'b100010: alucontrol <= 3'b110; // sub
         6'b100100: alucontrol <= 3'b000; // and
         6'b100101: alucontrol <= 3'b001; // or
         6'b101010: alucontrol <= 3'b111; // slt
         default: alucontrol <= 3'bxxx; // ???
      endcase
   endcase
endmodule




