




//modulo ring counter

module contatore_ad_anello(q,clock,reset_);
   input clock, reset_;
   output[3:0] q;
   reg[3:0]q;
   always @(posedge clock)
      if(!reset_)
         q <= 4'b1000;
      else
         begin
             q[3]<=q[0]; //chiusura anello
             q[2]<=q[3];
             q[1]<=q[2];
             q[0]<=q[1]; 
         end
endmodule



//testbench

`timescale 1ns/1ps
module TopLevel;
   reg clock,reset_;
   wire[3:0] Q;
   contatore_ad_anello rc(Q,clock,reset_);
   always #10 clock = ~clock;
   initial begin 
      $display("time, \t clock, \t reset_, \t QQQQ");
      $monitor("%g, \t %b, \t %b, \t %b",$time, clock,reset_,Q);
      reset_ = 1'b1;
      clock=0;
   #5 reset_ =1'b0;
   #20 reset_=1'b1;
   #600 $finish; 
   end
endmodule







