<?php
require 'common.php';

//#############################################################################
//###### Funzione che in prende una istruzione come una striga e la decodifica (3 tipi)
function decodeIstr($istr)
{
    $cmd=strtok($istr,' ');
    $a=substr($istr,strlen($istr)-(strlen($istr)-strlen($cmd)));
    $cmd=trim($cmd);

    switch ($cmd)
    {
        case 'add':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=32;
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'addi':
            $tipo='I';
            $op=8;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $imm='ERR';
                break;
            }
            $imm=strtok($a,PHP_EOL);
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            break;

        case 'sub':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=34;
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'div':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=26;
            $rd='$0';
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'mult':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=24;
            $rd='$0';
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'and':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=36;
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'andi':
            $tipo='I';
            $op=12;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $imm='ERR';
                break;
            }
            $imm=strtok($a,PHP_EOL);
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            break;

        case 'nor':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=39;
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'or':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=37;
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'ori':
            $tipo='I';
            $op=13;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $imm='ERR';
                break;
            }
            $imm=strtok($a,PHP_EOL);
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            break;

        case 'xor':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=38;
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'xori':
            $tipo='I';
            $op=14;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $imm='ERR';
                break;
            }
            $imm=strtok($a,PHP_EOL);
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            break;

        case 'sll':
            $tipo='R';
            $op=0;
            $funct=0;
            $rs='$0';
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rt='ERR';
                $shamt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rt='ERR';
                $shamt='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $shamt='ERR';
                break;
            }
            $shamt=strtok($a,PHP_EOL);
            $shamt=is_numeric(trim($shamt))?trim($shamt):'ERR';
            break;

        case 'srl':
            $tipo='R';
            $op=0;
            $funct=2;
            $rs='$0';
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rt='ERR';
                $shamt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rt='ERR';
                $shamt='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $shamt='ERR';
                break;
            }
            $shamt=strtok($a,PHP_EOL);
            $shamt=is_numeric(trim($shamt))?trim($shamt):'ERR';
            break;

        case 'lw':
            $tipo='I';
            $op=35;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $imm=strtok($a,'\(');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($imm)+1)));
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            if(strlen($a)==0 || $imm==='ERR')
            {
                $rs='ERR';
                break;
            }
            $rs=strtok($a,'\)');
            $rs=trim($rs);
            break;

        case 'lb':
            $tipo='I';
            $op=32;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $imm=strtok($a,'\(');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($imm)+1)));
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            if(strlen($a)==0 || $imm==='ERR')
            {
                $rs='ERR';
                break;
            }
            $rs=strtok($a,'\)');
            $rs=trim($rs);
            break;

        case 'lbu':
            $tipo='I';
            $op=36;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $imm=strtok($a,'\(');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($imm)+1)));
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            if(strlen($a)==0 || $imm==='ERR')
            {
                $rs='ERR';
                break;
            }
            $rs=strtok($a,'\)');
            $rs=trim($rs);
            break;

        case 'sw':
            $tipo='I';
            $op=43;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $imm=strtok($a,'\(');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($imm)+1)));
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            if(strlen($a)==0 || $imm==='ERR')
            {
                $rs='ERR';
                break;
            }
            $rs=strtok($a,'\)');
            $rs=trim($rs);
            break;

        case 'sb':
            $tipo='I';
            $op=40;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $imm='ERR';
                $rs='ERR';
                break;
            }
            $imm=strtok($a,'\(');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($imm)+1)));
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            if(strlen($a)==0 || $imm==='ERR')
            {
                $rs='ERR';
                break;
            }
            $rs=strtok($a,'\)');
            $rs=trim($rs);
            break;

        case 'beq':
            $tipo='I';
            $op=4;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $imm='ERR';
                break;
            }
            $imm=strtok($a,PHP_EOL);
            $imm=trim($imm);
            break;

        case 'bne':
            $tipo='I';
            $op=5;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $imm='ERR';
                break;
            }
            $imm=strtok($a,PHP_EOL);
            $imm=trim($imm);
            break;

        case 'slt':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=42;
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'slti':
            $tipo='I';
            $op=10;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $imm='ERR';
                break;
            }
            $imm=strtok($a,PHP_EOL);
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            break;

        case 'sltu':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=43;
            if(strlen($a)==0)
            {
                $rd='ERR';
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rd=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rd)+1)));
            $rd=trim($rd);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $rt='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $rt='ERR';
                break;
            }
            $rt=strtok($a,PHP_EOL);
            $rt=trim($rt);
            break;

        case 'sltiu':
            $tipo='I';
            $op=11;
            if(strlen($a)==0)
            {
                $rt='ERR';
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rt=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rt)+1)));
            $rt=trim($rt);
            if(strlen($a)==0)
            {
                $rs='ERR';
                $imm='ERR';
                break;
            }
            $rs=strtok($a,',');
            $a=substr($a,strlen($a)-(strlen($a)-(strlen($rs)+1)));
            $rs=trim($rs);
            if(strlen($a)==0)
            {
                $imm='ERR';
                break;
            }
            $imm=strtok($a,PHP_EOL);
            $imm=is_numeric(trim($imm))?trim($imm):'ERR';
            break;

        case 'j':
            $tipo='J';
            $op=2;
            if(strlen($a)==0)
            {
                $target='ERR';
                break;
            }
            $target=strtok($a,PHP_EOL);
            $target=trim($target);
            break;

        case 'jr':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=8;
            $rd='$0';
            $rt='$0';
            if(strlen($a)==0)
            {
                $rs='ERR';
                break;
            }
            $rs=strtok($a,PHP_EOL);
            $rs=trim($rs);
            break;

        case 'jal':
            $tipo='J';
            $op=3;
            if(strlen($a)==0)
            {
                $target='ERR';
                break;
            }
            $target=strtok($a,PHP_EOL);
            $target=trim($target);
            break;

        case 'mfhi':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=16;
            $rs='$0';
            $rt='$0';
            if(strlen($a)==0)
            {
                $rd='ERR';
                break;
            }
            $rd=strtok($a,PHP_EOL);
            $rd=trim($rd);
            break;

        case 'mflo':
            $tipo='R';
            $op=0;
            $shamt=0;
            $funct=18;
            $rs='$0';
            $rt='$0';
            if(strlen($a)==0)
            {
                $rd='ERR';
                break;
            }
            $rd=strtok($a,PHP_EOL);
            $rd=trim($rd);
            break;

        default:
            $tipo='ERR';
            $function_ret='ERR';
            break;
    }


    if ($tipo=='R')
    {
        $op=intval($op);
        $rs=decRegister($rs);
        $rt=decRegister($rt);
        $rd=decRegister($rd);
        $shamt=intval($shamt);
        $funct=intval($funct);

        if ($rs==='ERR' || $rt==='ERR' || $rd==='ERR' || $shamt>31)
        {
            $function_ret='ERR';
        }
        else
        {
            $rs=intval($rs);
            $rt=intval($rt);
            $rd=intval($rd);
            $function_ret=IntToBin($op,6,1).IntToBin($rs,5,1).IntToBin($rt,5,1).IntToBin($rd,5,1).IntToBin($shamt,5,1).IntToBin($funct,6,1);
        }
    }

    if ($tipo=='I')
    {
        $op=intval($op);
        $rs=decRegister($rs);
        $rt=decRegister($rt);

        if ($rs==='ERR' || $rt==='ERR' || $imm=='ERR')
        {
            $function_ret='ERR';
        }
        else
        {
            $rs=intval($rs);
            $rt=intval($rt);
            if ($cmd!='beq' && $cmd!='bne')
            {
                $imm=intval($imm);
                if ($cmd!='andi' && $cmd!='ori' && $cmd!='xori')
                    $imm=IntToBin($imm,16,0); //SignExt
                else
                    $imm=IntToBin($imm,16,1); //ZeroExt
            }
            else
            {
                $imm=':'.$imm;
            }

            $function_ret=IntToBin($op,6,1).IntToBin($rs,5,1).IntToBin($rt,5,1).$imm;
        }
    }

    if ($tipo=='J')
    {
        $op=intval($op);
        if ($target=='ERR')
        {
            $function_ret='ERR';
        }
        else
        {
            $function_ret=IntToBin($op,6,1).':'.$target;
        }
    }

    return $function_ret;
}
//#############################################################################

//#############################################################################
//###### Funzione che trasfroma registro stringa in numero corispodente
function decRegister($reg)
{
    switch ($reg)
    {
        case '$ze':
            $function_ret=0;
            break;

        case '$zero':
            $function_ret=0;
            break;

        case '$0':
            $function_ret=0;
            break;

        case '$s0':
            $function_ret=16;
            break;

        case '$s1':
            $function_ret=17;
            break;

        case '$s2':
            $function_ret=18;
            break;

        case '$s3':
            $function_ret=19;
            break;

        case '$s4':
            $function_ret=20;
            break;

        case '$s5':
            $function_ret=21;
            break;

        case '$s6':
            $function_ret=22;
            break;

        case '$s7':
            $function_ret=23;
            break;

        case '$t0':
            $function_ret=8;
            break;

        case '$t1':
            $function_ret=9;
            break;

        case '$t2':
            $function_ret=10;
            break;

        case '$t3':
            $function_ret=11;
            break;

        case '$t4':
            $function_ret=12;
            break;

        case '$t5':
            $function_ret=13;
            break;

        case '$t6':
            $function_ret=14;
            break;

        case '$t7':
            $function_ret=15;
            break;

        case '$t8':
            $function_ret=24;
            break;

        case '$t9':
            $function_ret=25;
            break;

        case '$a0':
            $function_ret=4;
            break;

        case '$a1':
            $function_ret=5;
            break;

        case '$a2':
            $function_ret=6;
            break;

        case '$a3':
            $function_ret=7;
            break;

        case '$v0':
            $function_ret=2;
            break;

        case '$v1':
            $function_ret=3;
            break;

        case '$gp':
            $function_ret=28;
            break;

        case '$sp':
            $function_ret=29;
            break;

        case '$fp':
            $function_ret=30;
            break;

        case '$ra':
            $function_ret=31;
            break;

        case '$as':
            $function_ret=1;
            break;

        default:
            $function_ret='ERR';
            break;
    }

    return $function_ret;
}
//#############################################################################

//###### Funzione che converte il nome del label all'indirizzo dove punta
function cLabel($label,$tabRil,$dimTabRil)
{
    $i=0;
    $function_ret='ERR';
    while($i<$dimTabRil)
    {
        $a1=$tabRil[$i];
        $b1=(strpos($a1,'|',1) ? strpos($a1,'|',1)+1 : 0);
        $c=substr($a1,$b1);
        //var_dump($a1,$b1,$c,$tabRil,$dimTabRil);
        if ($c==$label)
        {
            $function_ret=substr($a1,0,$b1-1);
            $function_ret=intval($function_ret);
            break;
        }
        $i=$i+1;
    }
    //var_dump($function_ret);
    return $function_ret;
}

//#############################################################################

//###### Funzione che trasfroma numero corispodente di un registro in stringa $xx
function codRegister($reg)
{

    $reg=intval($reg);
    switch ($reg)
    {
        case 0:
            $function_ret='$0';
            break;

        case 16:
            $function_ret='$s0';
            break;

        case 17:
            $function_ret='$s1';
            break;

        case 18:
            $function_ret='$s2';
            break;

        case 19:
            $function_ret='$s3';
            break;

        case 20:
            $function_ret='$s4';
            break;

        case 21:
            $function_ret='$s5';
            break;

        case 22:
            $function_ret='$s6';
            break;

        case 23:
            $function_ret='$s7';
            break;

        case 8:
            $function_ret='$t0';
            break;

        case 9:
            $function_ret='$t1';
            break;

        case 10:
            $function_ret='$t2';
            break;

        case 11:
            $function_ret='$t3';
            break;

        case 12:
            $function_ret='$t4';
            break;

        case 13:
            $function_ret='$t5';
            break;

        case 14:
            $function_ret='$t6';
            break;

        case 15:
            $function_ret='$t7';
            break;

        case 24:
            $function_ret='$t8';
            break;

        case 25:
            $function_ret='$t9';
            break;

        case 4:
            $function_ret='$a0';
            break;

        case 5:
            $function_ret='$a1';
            break;

        case 6:
            $function_ret='$a2';
            break;

        case 7:
            $function_ret='$a3';
            break;

        case 2:
            $function_ret='$v0';
            break;

        case 3:
            $function_ret='$v1';
            break;

        case 28:
            $function_ret='$gp';
            break;

        case 29:
            $function_ret='$sp';
            break;

        case 30:
            $function_ret='$fp';
            break;

        case 31:
            $function_ret='$ra';
            break;

        case 1:
            $function_ret='$as';
            break;

        default:
            $function_ret='';
            break;
    }

    return $function_ret;
}
//#############################################################################

//###### Funzione che identifica la istruzione di tipo R
function idenIstrR($funzione)
{



    $funzione=intval($funzione);
    switch ($funzione)
    {
        case 32:
            $function_ret='Add';

            break;
        case 34:
            $function_ret='Sub';

            break;
        case 24:
            $function_ret='Mult';

            break;
        case 26:
            $function_ret='Div';

            break;
        case 32:
            $function_ret='Add';

            break;
        case 36:
            $function_ret='And';

            break;
        case 39:
            $function_ret='Nor';

            break;
        case 37:
            $function_ret='Or';

            break;
        case 38:
            $function_ret='Xor';

            break;
        case 0:
            $function_ret='Sll';

            break;
        case 2:
            $function_ret='Srl';

            break;
        case 42:
            $function_ret='Slt';

            break;
        case 43:
            $function_ret='Sltu';

            break;
        case 8:
            $function_ret='Jr';

            break;
        case 16:
            $function_ret='Mfhi';

            break;
        case 18:
            $function_ret='Mflo';

            break;
        default:

            $function_ret='';
            break;
    }
    return $function_ret;
}
//#############################################################

//###### Funzione che identifica la istruzione di tipo R
function idenIstrI($operazione)
{


    $operazione=intval($operazione);
    switch ($operazione)
    {
        case 8:
            $operazione='Addi';

            break;
        case 12:
            $operazione='Andi';

            break;
        case 13:
            $operazione='Ori';

            break;
        case 14:
            $operazione='Xori';

            break;
        case 10:
            $operazione='Slti';

            break;
        case 11:
            $operazione='Sltiu';

            break;
        case 4:
            $operazione='Beq';

            break;
        case 5:
            $operazione='Bne';

            break;
        case 32:
            $operazione='Lb';

            break;
        case 36:
            $operazione='Lbu';

            break;
        case 35:
            $operazione='Lw';

            break;
        case 40:
            $operazione='Sb';

            break;
        case 43:
            $operazione='Sw';

            break;
        default:

            $operazione='';

            break;
    }
    $function_ret=$operazione;
    return $function_ret;
}
//#########################################################

//###### Funzione che identifica la istruzione di tipo R
function idenIstrJ($operazione)
{


    $operazione=intval($operazione);
    switch ($operazione)
    {
        case 2:
            $operazione='J';

            break;
        case 3:
            $operazione='Jal';

            break;
        default:

            $operazione='';

            break;
    }
    $function_ret=$operazione;
    return $function_ret;
}
//#########################################################

?>

