<?php
//#############################################################################
//###### Funzione che converte un numero intero in un numero binario
function IntToBin($intero,$lunghezza,$istruzione)
{
    $num=$intero;
    $intero=abs($intero);
    $risultato='';

    while($intero!=1 && $intero!=0)
    {
        $i=fmod($intero,2);
        $intero=($intero-$i)/2;
        $risultato=$i.$risultato;

    }
    if ($intero!=0)
    {
        $risultato="1".$risultato;
    }
    else
    {
        $risultato="0";
    }

    if ($istruzione!=1) //numero
    {
        if ($num>=0)
        {
            if (strlen($risultato)<$lunghezza)
            {
                $i=$lunghezza-strlen($risultato);
                while($i!=0)
                {
                    $risultato="0".$risultato;
                    $i=$i-1;
                }
            }
        }
        else
        {
            $risultato=twoComplement($risultato);
            if (strlen($risultato)<$lunghezza)
            {
                $i=$lunghezza-strlen($risultato);
                while($i!=0)
                {
                    $risultato="1".$risultato;
                    $i=$i-1;
                }
            }
        }
    }
    else //istruzione
    {
        if (strlen($risultato)<$lunghezza)
        {
            $i=$lunghezza-strlen($risultato);
            while($i!=0)
            {
                $risultato="0".$risultato;
                $i=$i-1;
            }
        }
    }

    $function_ret=$risultato;
    return $function_ret;
}
//#############################################################################

//#############################################################################
//#### Funzione che converte un numero binario in un numero intero
function BinToInt($stringa,$istruzione)
{
    $lunghezza=strlen($stringa);
    if ($lunghezza!=0)
    {
        if( $stringa[0]=='1' && $lunghezza!=1 && $istruzione!=1)
        {
            $stringa=twoComplement($stringa);
            $j=0;
            $k=0;
            $l=0;
            while($lunghezza!=$l)
            {
                $i=substr($stringa,$lunghezza-1,1);
                $i=intval($i);
                $k=$k+($i*pow(2,$j));
                $j=$j+1;
                $lunghezza=$lunghezza-1;
            }
            $k=-$k;
            $function_ret=$k;
        }
        else
        {
            $j=0;
            $k=0;
            $l=0;
            while($lunghezza!=$l)
            {
                $i=substr($stringa,$lunghezza-1,1);
                $i=intval($i);
                $k=$k+($i*pow(2,$j));
                $j=$j+1;
                $lunghezza=$lunghezza-1;
            }
            $function_ret=$k;
        }
    }
    else
    {
        $function_ret=0;
    }

    return $function_ret;
}
//#############################################################################

//#############################################################################
//#### Funzione complemento a due binario
function twoComplement($str)
{
    $n = strlen($str);
    // Traverse the string to get first '1' from the last of string
    for ($i = $n-1 ; $i >= 0 ; $i--)
        if ($str[$i] == '1')
            break;
    // If there exists no '1' exit
    if ($i == -1)
        return $str;

    // Continue traversal after the position of first '1'
    for ($k = $i-1 ; $k >= 0; $k--)
    {
        //flip the values
        if ($str[$k] == '1')
            $str[$k] = '0';
        else
            $str[$k] = '1';
    }

    return $str;
}
//#############################################################################

//#############################################################################
function notNostra($stringa)
{
    $i=1;
    $risultato="";

    while($i!=33)
    {
        $prova3=substr($stringa,$i-1,1);
        if ($prova3=="0")
        {
            $prova3="1";
        }
        else
        {
            $prova3="0";
        }

        $risultato=$risultato.$prova3;
        $i=$i+1;
    }

    $function_ret=$risultato;
    return $function_ret;
}
//#############################################################################

//#############################################################################
function ALU($controllo,$dato1,$dato2)
{
    $dato1=intval($dato1);
    $dato2=intval($dato2);

    switch ($controllo)
    {
        case "0000": //AND:
            $risultato=$dato1 & $dato2;
            break;

        case "0011": //XOR:
            $risultato=$dato1 ^ $dato2;
            break;

        case "1100": //NOR
            $risultato=$dato1 | $dato2;
            $risultato=IntToBin($risultato,32,1);
            $risultato=notNostra($risultato);
            $risultato=BinToInt($risultato,1);
            break;

        case "0001": //OR:
            $risultato=$dato1 | $dato2;
            break;

        case "0010": //SOMMA:
            $risultato=$dato1+$dato2;
            break;

        case "0110": //SOTTRAZIONE:
            $risultato=$dato1-$dato2;
            break;

        case "0111": //SET ON LESS THEN:
            if ($dato1<$dato2)
            {
                $risultato=1;
            }
            else
            {
                $risultato=0;
            }
            break;

        case "0100": //SET ON LESS THEN IMMEDIATE UNSIGNED:
            $dato1=abs($dato1); //valore assoluto
            $dato2=abs($dato2);
            if ($dato1<$dato2)
            {
                $risultato=1;
            }
            else
            {
                $risultato=0;
            }
            break;

        case "1000": //Multiplicazione:
            $HILO=$dato1*$dato2;
            $_SESSION['HILO']=$HILO;
            $risultato=0;
            break;

        case "1001": //Divisione:
            $HI_val=$dato1%$dato2;
            $LO_val=($dato1-$HI_val)/$dato2;
            $HILO_val=IntToBin($HI_val,32,0).IntToBin($LO_val,32,0);
            $HILO=BinToInt($HILO_val,0);
            $_SESSION['HILO']=$HILO;
            $risultato=0;
            break;

        case "1010": //MFHI:
            $HILO=$_SESSION['HILO'];
            $HI=BinToInt(substr(IntToBin($HILO,64,0),0,32),0);
            $risultato=$HI;
            break;

        case "1011": //MFLO:
            $HILO=$_SESSION['HILO'];
            $LO=BinToInt(substr(IntToBin($HILO,64,0),32,32),0);
            $risultato=$LO;
            break;

        case "1110": //SLL:
            $risultato=$dato2<<$dato1;
            break;

        case "1111": //SRL:
            $risultato=$dato2>>$dato1;
            break;

        default:
            $risultato=0;
            break;
    }

    $function_ret=$risultato;

    return $function_ret;
}
//#############################################################################

//#############################################################################
function IDMux($controllo1,$controllo2,$dato1,$dato2)
{
    $a=$controllo1.$controllo2;

    switch ($a)
    {
        case "10":
            $function_ret=$dato1;
            break;
        case "01":
            $function_ret=4;
            break;
        case "00":
            $function_ret=$dato2;
            break;
        default:

            $function_ret=0;

            break;
    }
    return $function_ret;
}
//#############################################################################

//#############################################################################
function EXMux3($MUX3controllo,$dato1,$dato2,$dato3)
{
    switch ($MUX3controllo)
    {
        case "00":
            $function_ret=$dato1;
            break;
        case "01":
            $function_ret=$dato2;
            break;
        case "10":
            $function_ret=$dato3;
            break;
        default:
            $function_ret=0;
            break;
    }
    return $function_ret;
}
//#############################################################################

//#############################################################################
function EXMux7($MUX7controllo,$dato1,$dato2)
{
    $MUX7controllo=intval($MUX7controllo);

    switch ($MUX7controllo)
    {
        case 1:
            $function_ret=$dato1;
            break;

        case 0:
            $function_ret=$dato2;
            break;

        default:
            $function_ret=0;
            break;
    }
    return $function_ret;
}
//#############################################################################

//#############################################################################
function EXMux4($MUX4controllo,$dato1,$dato2,$dato3)
{
    switch ($MUX4controllo)
    {
        case "00":
            $function_ret=$dato1;
            break;
        case "01":
            $function_ret=$dato2;
            break;
        case "10":
            $function_ret=$dato3;
            break;
        default:

            $function_ret=0;

            break;
    }
    return $function_ret;
}
//#############################################################################

//#############################################################################
function EXMux5($MUX5controllo,$dato1,$dato2)
{
    $MUX5controllo=intval($MUX5controllo);

    switch ($MUX5controllo)
    {
        case 0:
            $function_ret=$dato1;
            break;

        case 1:
            $function_ret=$dato2;
            break;

        default:
            $function_ret=0;
            break;
    }
    return $function_ret;
}
//#############################################################################

//#############################################################################
function UnitaDiCtrl($instruction,$signal)
{
    $op=substr($instruction,0,6);
    $op=BinToInt($op,1);
    $op=intval($op);

    $funct=substr($instruction,strlen($instruction)-(6));
    $funct=BinToInt($funct,1);
    $funct=intval($funct);

    $function_ret=null;

    switch ($op)
    {
        case 0://tipo R
            if ((BinToInt(substr($instruction,strlen($instruction)-(6)),1)==0)&&(BinToInt(substr($instruction,strlen($instruction)-(11),5),1)==0))
            {//stallo
                $ex="0000";
                $mem="000";
                $wb="00";
            }
            else
            {
                $ex="1100";
                $mem="000";
                $wb="10";
            }
            break;

        case 8://addi
            $ex="0101";
            $mem="000";
            $wb="10";
            break;

        case 12://andi
            $ex="0101";
            $mem="000";
            $wb="10";
            break;

        case 13://ori
            $ex="0101";
            $mem="000";
            $wb="10";
            break;

        case 14://xori
            $ex="0101";
            $mem="000";
            $wb="10";
            break;

        case 10://slti
            $ex="0101";
            $mem="000";
            $wb="10";
            break;

        case 11://sltiu
            $ex="0101";
            $mem="000";
            $wb="10";
            break;

        case 4://beq
            $ex="0000";
            $mem="000";
            $wb="00";
            break;

        case 5://bne
            $ex="0000";
            $mem="000";
            $wb="00";
            break;

        case 32://lb
            $ex="0001";
            $mem="100";
            $wb="11";
            break;

        case 36://lbu
            $ex="0001";
            $mem="100";
            $wb="11";
            break;

        case 35://lw
            $ex="0001";
            $mem="101";
            $wb="11";
            break;

        case 40://sb
            $ex="0001";
            $mem="010";
            $wb="01";
            break;

        case 43://sw
            $ex="0001";
            $mem="011";
            $wb="01";
            break;

        default:
            $ex="0000";
            $mem="00";
            $wb="00";
            break;
    }

    switch ($signal)
    {
        case "Salta":
            if ($op==2 || $op==3 || $op==4 || $op==5 || $funct==8)
            {
                $function_ret=1;
            }
            else
            {
                $function_ret=0;
            }
            break;

        case "PCsrc":
			//caso delle eccezioni.... ??????????
			$function_ret=0;
            break;

        case "WB":
            $function_ret=$wb;
            break;

        case "M":
            $function_ret=$mem;
            break;

        case "EX":
            $function_ret=$ex;
            break;
    }

    return $function_ret;
}
//#############################################################################

//#############################################################################
function UnitaCtrlAlu($ctrl,$funct,$op)
{
    $funct=BinToInt($funct,1);
    $mux_ret=0;
	$function_ret='';
    switch ($ctrl)
    {
        case "00": //caso delle lw, sw, lb, lbu, sb:
            $function_ret="0010";
            break;

        case "01":
            $function_ret="0110";
            break;

        case "10": //Tipo R:
            if ($op==0)
            {
                switch ($funct)
                {
                    case 32: //somma:
                        $function_ret="0010";
                        break;

                    case 34: //sottrazione:
                        $function_ret="0110";
                        break;

                    case 36: //and:
                        $function_ret="0000";
                        break;

                    case 37: //or:
                        $function_ret="0001";
                        break;

                    case 38: //xor:
                        $function_ret="0011";
                        break;

                    case 39: //nor:
                        $function_ret="1100"; //"0101";
                        break;

                    case 42: //slt:
                        $function_ret="0111";
                        break;

                    case 43: //sltu:
                        $function_ret="0100";
                        break;

                    case 24: //mult:
                        $function_ret="1000";
                        break;

                    case 26: //div:
                        $function_ret="1001";
                        break;

                    case 16: //mfhi:
                        $function_ret="1010";
                        break;

                    case 18: //mflo:
                        $function_ret="1011";
                        break;

                    case 0: //sll:
                        $function_ret="1110";
                        $mux_ret=1;
                        break;

                    case 2: //srl:
                        $function_ret="1111";
                        $mux_ret=1;
                        break;

                }
            }
            else
            {
                switch ($op)
                {
                    case 8: //addi:
                        $function_ret="0010";
                        break;

                    case 12: //andi:
                        $function_ret="0000";
                        break;

                    case 13: //ori:
                        $function_ret="0001";
                        break;

                    case 14: //xori:
                        $function_ret="0011";
                        break;

                    case 10: //slti:
                        $function_ret="0111";
                        break;

                    case 11: //sltiu:
                        $function_ret="0100";
                        break;
                }
            }
            break;
    }
    return array($function_ret,$mux_ret);
}
//#############################################################################
?>

